<?php
/**
 * File containing the ezcWebdavHeadResponse class.
 *
 * @package Webdav
 * @version //autogentag//
 * @copyright Copyright (C) 2005-2010 eZ Systems AS. All rights reserved.
 * @license http://ez.no/licenses/new_bsd New BSD License
 */
/**
 * Class generated by the backend to respond to HEAD requests on a resource.
 *
 * If a {@link ezcWebdavBackend} receives an instance of {@link
 * ezcWebdavHeadRequest} it might react with an instance of {@link
 * ezcWebdavHeadResponse} or with producing an error.
 *
 * @version //autogentag//
 * @package Webdav
 */
class ezcWebdavHeadResponse extends ezcWebdavResponse
{
    /**
     * Creates a new response object.
     *
     * Construct head response for {@link ezcWebdavResource} or {@link
     * ezcWebdavCollection}.
     * 
     * @param ezcWebdavResource|ezcWebdavCollection $resource 
     * @return void
     */
    public function __construct( $resource )
    {
        parent::__construct( ezcWebdavResponse::STATUS_200 );

        $this->resource = $resource;
    }

    /**
     * Sets a property.
     *
     * This method is called when an property is to be set.
     * 
     * @param string $propertyName The name of the property to set.
     * @param mixed $propertyValue The property value.
     * @return void
     * @ignore
     *
     * @throws ezcBasePropertyNotFoundException
     *         if the given property does not exist.
     * @throws ezcBaseValueException
     *         if the value to be assigned to a property is invalid.
     * @throws ezcBasePropertyPermissionException
     *         if the property to be set is a read-only property.
     */
    public function __set( $propertyName, $propertyValue )
    {
        switch ( $propertyName )
        {
            case 'resource':
                if ( ( ! $propertyValue instanceof ezcWebdavResource ) &&
                     ( ! $propertyValue instanceof ezcWebdavCollection ) )
                {
                    throw new ezcBaseValueException( $propertyName, $propertyValue, 'ezcWebdavResource or ezcWebdavCollection' );
                }

                $this->properties[$propertyName] = $propertyValue;
                break;

            default:
                parent::__set( $propertyName, $propertyValue );
        }
    }
}

?>
