{* DO NOT EDIT THIS FILE! Use an override template instead. *}
{let package=fetch( package,item,
                    hash( package_name, $package_name,
                          repository_id, $repository_id ) )}

<div class="context-block">

<div id="package" class="viewfull">
    <div id="pn-{$package.name|wash}" class="pt-{$package.type|wash}">


{* DESIGN: Header START *}<div class="box-header"><div class="box-ml">
<h1 class="context-title">
        {$package.name|wash}-{$package.version-number}-{$package.release-number}{if $package.release-timestamp}({$package.release-timestamp|l10n( shortdatetime )}){/if}{if $package.type|wash} [{$package.type}]{/if}
        - {if $package.install_type|eq( 'install' )}
            {if $package.is_installed}
                {'Installed'|i18n('design/admin/package')}
            {else}
                {'Not installed'|i18n('design/admin/package')}
            {/if}
        {else}
            {'Imported'|i18n('design/admin/package')}
        {/if}
</h1>

{* DESIGN: Mainline *}<div class="header-mainline"></div>

{* DESIGN: Header END *}</div></div>

{* DESIGN: Content START *}<div class="box-ml"><div class="box-mr"><div class="box-content">

<div class="context-attributes">

    <form method="post" action={concat( 'package/view/full/', $package.name )|ezurl}>

    <div class="object">

        <table>
        <tr>
        <td>

        <div class="summary">
            <label>{'Summary'|i18n('design/admin/package')}</label>
            <p>{$package.summary|wash}</p>
        </div>

        <div class="state">
            <label>{'State'|i18n('design/admin/package')}</label>
            <p>{$package.state|wash}</p>
        </div>

        <div class="licence">
            <label>{'License'|i18n('design/admin/package')}</label>
            <p>{$package.licence|wash}</p>
        </div>

        <div class="maintainers">
            <label>{'Maintainers'|i18n('design/admin/package')}</label>
            <p>
                {section var=maintainer loop=$package.maintainers}
                    <a href="mailto:{$maintainer.item.email}" subject="{"Regarding eZ Publish package '%packagename'"|i18n('design/admin/package',,hash( '%packagename', $package.name ) )}" title="{'Send email to the maintainer'|i18n('design/admin/package')}">{$maintainer.item.name|wash}</a> ({$maintainer.item.role|wash})
                {delimiter}, {/delimiter}
                {/section}
            </p>
        </div>

        <div class="description">
            <label>{'Description'|i18n('design/admin/package')}</label>
            <p>{$package.description}</p>
        </div>

        <div class="documents">
            <label>{'Documents'|i18n('design/admin/package')}</label>
            <p>
                {section var=document loop=$package.documents}
                {let document_path=$package|ezpackage( documentpath, $document.name )}
                    {if $document_path}<a href={$document_path|ezroot}>{/if}{$document.name|wash}{if $document_path}</a>{/if}
                {/let}
                {delimiter}, {/delimiter}
                {/section}
            </p>
        </div>

        <div class="changelog">
            <label>{'Changelog'|i18n('design/admin/package')}</label>
            <p>
                {section var=log loop=$package.changelog}
                    <h3><p class="byline"><em class="date">({$log.item.timestamp|l10n( shortdatetime )})</em> <a href="mailto:{$log.item.email}" subject="{"Regarding eZ Publish package '%packagename'"|i18n('design/admin/package',,hash( '%packagename', $package.name ) )}" title="{'Send email to the maintainer'|i18n('design/admin/package')}">{$log.item.person|wash}</a></p></h3>
                    <ul>
                    {section var=change loop=$log.item.changes}
                    <li>
                        {$change.item|wash}
                    </li>
                    {/section}
                    </ul>
                {delimiter}<hr/> {/delimiter}
                {/section}
            </p>
        </div>

        </td>

        <td valign="top">
            {let thumbnail_list=$package.thumbnail-list}
            {if $thumbnail_list}
            <div class="thumbnail">
                <img src={concat( $package|ezpackage( fileitempath, $thumbnail_list[0] ) )|ezroot} alt="{$thumbnail_list[0].name|wash}" />
            </div>
            {/if}
            {/let}
        </td>

        </tr>
        </table>

    </div>

    <div class="links">
        {if $package.file-count|gt( 0 )}
        <p>[ <a href={concat( "package/view/files/", $package.name )|ezurl}>{'File list'|i18n('design/admin/package')}</a> ]</p>
        {/if}
    </div>

    </div>
    {* DESIGN: Content END *}</div></div></div>

    <div class="controlbar">
    {* DESIGN: Control bar START *}<div class="box-bc"><div class="box-ml">


    {if $package.can_export}
    <div class="block">
        {if $package.install_type|eq( 'install' )}
            {if $package.is_installed}
                <input class="button" type="submit" name="UninstallButton" value="{'Uninstall'|i18n( 'design/admin/package')}" />
            {else}
                <input class="button" type="submit" name="InstallButton" value="{'Install'|i18n( 'design/admin/package')}" />
            {/if}
        {/if}
        <input class="button" type="submit" name="ExportButton" value="{'Export to file'|i18n( 'design/admin/package')}" />
    </div>
    {/if}

    </form>

    </div>
    {* DESIGN: Control bar END *}</div></div>


    </div>
</div>

</div>

{/let}
