/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.filter;

import org.carrot2.core.attribute.Processing;
import org.carrot2.text.linguistic.ILexicalData;
import org.carrot2.text.preprocessing.LabelFormatter;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.filter.SingleLabelFilterBase;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Input;

@Bindable(prefix="StopLabelFilter")
public class StopLabelFilter
extends SingleLabelFilterBase {
    @Input
    @Processing
    @Attribute
    public boolean enabled = true;
    private final LabelFormatter labelFormatter = new LabelFormatter();
    private ILexicalData lexicalData;

    public void filter(PreprocessingContext context, boolean[] acceptedStems, boolean[] acceptedPhrases) {
        this.lexicalData = context.language.getLexicalData();
        super.filter(context, acceptedStems, acceptedPhrases);
    }

    public boolean acceptPhrase(PreprocessingContext context, int phraseIndex) {
        String formatedLabel = this.labelFormatter.format(context, phraseIndex + context.allWords.image.length);
        return !this.lexicalData.isStopLabel(formatedLabel);
    }

    public boolean acceptWord(PreprocessingContext context, int wordIndex) {
        String formattedLabel = this.labelFormatter.format(context, wordIndex);
        return !this.lexicalData.isStopLabel(formattedLabel);
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

