{* DO NOT EDIT THIS FILE! Use an override template instead. *}
{*?template charset=latin1?*}

<div align="center">
  <h1>{"Database initialization"|i18n("design/standard/setup/init")}</h1>
</div>

{if $db_error}
  <blockquote class="error">
  <p>
      {$db_error.text}
  </p>
  {if $db_error.url}
      <a href="{$db_error.url.href}" target="_other">{$db_error.url.text|wash}</a>
  {/if}
  </blockquote>
{/if}

<p>
{"Please input database access information in the form below."|i18n("design/standard/setup/init")}
</p>

<form method="post" action="{$script}">

{if eq( $db_not_empty, 1 )}
<h2>{"Warning"|i18n("design/standard/setup/init")}</h2>
<p>
 {"Your database already contains data."|i18n("design/standard/setup/init")}
 {"The setup can continue with the initialization but may damage the present data."|i18n("design/standard/setup/init")}
</p>
<p>
 {"What do you want the setup to do?"|i18n("design/standard/setup/init")}
</p>

<blockquote class="note">
<p>
 <b>{"Note"|i18n("design/standard/setup/init")}:</b>
 {"The setup will not do an upgrade from older eZ Publish versions (such as 2.2.7) if you leave the data as it is. This is only meant for people who have existing data that they don't want to lose. If you have existing eZ Publish 4.0 data (such as from an RC release) you should skip DB initialization, however you will then need to do a manual upgrade."|i18n("design/standard/setup/init")}
</p>
</blockquote>

<fieldset>
<legend>{"Database choice"|i18n( 'design/standard/setup/init' )}:</legend>

<table cellspacing="3" cellpadding="0" border="0">
<tr>
 <td class="normal">
  <p>{"Continue but leave the data as it is."|i18n("design/standard/setup/init")}</p>
 </td>
 <td rowspan="4" class="normal">
  &nbsp;&nbsp;
 </td>
 <td class="normal">
  <input type="radio" name="eZSetupDatabaseDataChoice" value="1" />
 </td>
</tr>
<tr>
 <td class="normal">
  <p>{"Continue but remove the data first."|i18n("design/standard/setup/init")}</p>
 </td>
 <td class="normal">
  <input type="radio" name="eZSetupDatabaseDataChoice" value="2"  checked="checked" />
 </td>
</tr>
<tr>
 <td class="normal">
  <p>{"Keep data and skip database initialization."|i18n("design/standard/setup/init")}</p>
 </td>
 <td class="normal">
  <input type="radio" name="eZSetupDatabaseDataChoice" value="3" />
 </td>
</tr>
<tr>
 <td class="normal">
  <p>{"Let me choose a new database."|i18n("design/standard/setup/init")}</p>
 </td>
 <td class="normal">
  <input type="radio" name="eZSetupDatabaseDataChoice" value="4" />
 </td>
</tr>
</table>
</fieldset>
{/if}

<fieldset>
<legend>{'Database'|i18n( 'design/standard/setup/init' )}:</legend>
<table border="0" cellspacing="3" cellpadding="0">
<tr>
  <th class="label" colspan="3"></th>
</tr>
<tr>
  <td class="normal"><label class="textfield">{"Type"|i18n("design/standard/setup/init")}</label></td>
  <td rowspan="7" class="normal">&nbsp;&nbsp;</td>
  <td class="normal">
  {$database_info.info.name|wash}
  </td>
</tr>

<tr>
  <td class="normal"><label class="textfield">{"Servername"|i18n("design/standard/setup/init")}:</label></td>
  <td class="normal"><input type="text" name="eZSetupDatabaseServer" size="16" value="{$database_info.server|wash}" /></td>
</tr>
<tr>
  <td class="normal"><label class="textfield">{"Port"|i18n("design/standard/setup/init")}:</label></td>
  <td class="normal"><input type="text" name="eZSetupDatabasePort" size="16" value="{$database_info.port|wash}" /></td>
</tr>
<tr>
  <td class="normal"><label class="textfield">{"Username"|i18n("design/standard/setup/init")}:</label></td>
  <td class="normal"><input type="text" name="eZSetupDatabaseUser" size="16" value="{$database_info.user|wash}" /></td>
</tr>
<tr>
  <td class="normal"><label class="textfield">{"Password"|i18n("design/standard/setup/init")}:</label></td>
  <td class="normal"><input type="password" name="eZSetupDatabasePassword" size="16" value="{$database_info.password|wash}" /></td>
</tr>
{if or(eq($database_info.info.driver,'ezmysql'), eq($database_info.info.driver,'ezmysqli'))}
<tr>
  <td class="normal"><label class="textfield">{"Socket (optional)"|i18n("design/standard/setup/init")}:</label></td>
  <td class="normal"><input type="text" name="eZSetupDatabaseSocket" size="16" value="{$database_info.socket|wash}" /></td>
</tr>
{/if}
</table>
</fieldset>
  {include uri='design:setup/init/navigation.tpl'}
  {include uri="design:setup/persistence.tpl"}
</form>
