<?php
/**
 * Autoloader definition for the Document component.
 *
 * @copyright Copyright (C) 2005-2010 eZ Systems AS. All rights reserved.
 * @license http://ez.no/licenses/new_bsd New BSD License
 * @version //autogentag//
 * @filesource
 * @package Document
 */

return array(
    'ezcDocumentException'                               => 'Document/exceptions/exception.php',
    'ezcDocumentConversionException'                     => 'Document/exceptions/conversion.php',
    'ezcDocumentErroneousXmlException'                   => 'Document/exceptions/erroneous_xml.php',
    'ezcDocumentInvalidDocbookException'                 => 'Document/exceptions/invalid_docbook.php',
    'ezcDocumentInvalidFontException'                    => 'Document/exceptions/unknown_font.php',
    'ezcDocumentInvalidOdtException'                     => 'Document/exceptions/invalid_odt.php',
    'ezcDocumentMissingVisitorException'                 => 'Document/exceptions/missing_visitor.php',
    'ezcDocumentOdtFormattingPropertiesExistException'   => 'Document/exceptions/odt/formatting_properties_exist.php',
    'ezcDocumentParserException'                         => 'Document/exceptions/parser.php',
    'ezcDocumentRstMissingDirectiveHandlerException'     => 'Document/exceptions/missing_directive_handler.php',
    'ezcDocumentRstMissingTextRoleHandlerException'      => 'Document/exceptions/missing_text_role_handler.php',
    'ezcDocumentRstTokenizerException'                   => 'Document/exceptions/rst_tokenizer.php',
    'ezcDocumentVisitException'                          => 'Document/exceptions/visitor.php',
    'ezcDocumentWikiMissingPluginHandlerException'       => 'Document/exceptions/missing_plugin_handler.php',
    'ezcDocumentWikiTokenizerException'                  => 'Document/exceptions/wiki_tokenizer.php',
    'ezcDocumentPdfRenderer'                             => 'Document/document/pdf/renderer.php',
    'ezcDocumentBBCodeNode'                              => 'Document/document/bbcode/node.php',
    'ezcDocumentElementVisitorHandler'                   => 'Document/converters/element_visitor_handler.php',
    'ezcDocumentErrorReporting'                          => 'Document/interfaces/error_reporting.php',
    'ezcDocumentPdfBlockRenderer'                        => 'Document/document/pdf/renderer/block.php',
    'ezcDocumentWikiNode'                                => 'Document/document/wiki/node.php',
    'ezcDocumentWikiToken'                               => 'Document/document/wiki/token.php',
    'ezcDocument'                                        => 'Document/interfaces/document.php',
    'ezcDocumentBBCodeBlockLevelNode'                    => 'Document/document/bbcode/nodes/block.php',
    'ezcDocumentConverter'                               => 'Document/interfaces/converter.php',
    'ezcDocumentConverterOptions'                        => 'Document/options/converter.php',
    'ezcDocumentDocbookToRstBaseHandler'                 => 'Document/converters/element_visitor/docbook/rst/handler.php',
    'ezcDocumentDocbookToWikiBaseHandler'                => 'Document/converters/element_visitor/docbook/wiki/handler.php',
    'ezcDocumentListItemGenerator'                       => 'Document/document/pdf/item_generator.php',
    'ezcDocumentOptions'                                 => 'Document/options/document.php',
    'ezcDocumentPcssStyleValue'                          => 'Document/pcss/style/value.php',
    'ezcDocumentPdfPart'                                 => 'Document/document/pdf/part.php',
    'ezcDocumentPdfTextBoxRenderer'                      => 'Document/document/pdf/renderer/text_box.php',
    'ezcDocumentRstDirective'                            => 'Document/document/rst/directive.php',
    'ezcDocumentRstNode'                                 => 'Document/document/rst/node.php',
    'ezcDocumentRstVisitor'                              => 'Document/document/rst/visitor.php',
    'ezcDocumentRstXhtmlDirective'                       => 'Document/interfaces/rst_xhtml_directive.php',
    'ezcDocumentValidation'                              => 'Document/interfaces/validation.php',
    'ezcDocumentWikiBlockLevelNode'                      => 'Document/document/wiki/nodes/block.php',
    'ezcDocumentWikiBlockMarkupToken'                    => 'Document/document/wiki/token/block_markup.php',
    'ezcDocumentWikiInlineMarkupToken'                   => 'Document/document/wiki/token/inline_markup.php',
    'ezcDocumentWikiInlineNode'                          => 'Document/document/wiki/nodes/inline.php',
    'ezcDocumentAlnumListItemGenerator'                  => 'Document/document/pdf/item_generator/alnum.php',
    'ezcDocumentBBCodeListNode'                          => 'Document/document/bbcode/nodes/list.php',
    'ezcDocumentBBCodePlugin'                            => 'Document/document/bbcode/plugin.php',
    'ezcDocumentBBCodeToken'                             => 'Document/document/bbcode/token.php',
    'ezcDocumentBBCodeVisitor'                           => 'Document/document/bbcode/visitor.php',
    'ezcDocumentDocbookToHtmlBaseHandler'                => 'Document/converters/element_visitor/docbook/xhtml/handler.php',
    'ezcDocumentDocbookToOdtBaseHandler'                 => 'Document/converters/element_visitor/docbook/odt/element_handlers/handler.php',
    'ezcDocumentDocbookToRstMediaObjectHandler'          => 'Document/converters/element_visitor/docbook/rst/mediaobject.php',
    'ezcDocumentDocbookToWikiMediaObjectHandler'         => 'Document/converters/element_visitor/docbook/wiki/mediaobject.php',
    'ezcDocumentElementVisitorConverter'                 => 'Document/converters/element_visitor.php',
    'ezcDocumentEzXmlLinkConverter'                      => 'Document/interfaces/ezxml_link_converter.php',
    'ezcDocumentEzXmlLinkProvider'                       => 'Document/interfaces/ezxml_link_provider.php',
    'ezcDocumentHtmlConverterOptions'                    => 'Document/options/html_rendering.php',
    'ezcDocumentLocateable'                              => 'Document/interfaces/locateable.php',
    'ezcDocumentOdtBaseFilter'                           => 'Document/document/xml/odt/filter/base.php',
    'ezcDocumentOdtElementBaseFilter'                    => 'Document/document/xml/odt/filter/element/base.php',
    'ezcDocumentOdtListLevelStyle'                       => 'Document/document/xml/odt/list_level_style.php',
    'ezcDocumentOdtPcssConverter'                        => 'Document/converters/element_visitor/docbook/odt/styler/pcss/converter.php',
    'ezcDocumentOdtStyleFilterRule'                      => 'Document/document/xml/odt/filter/style/rule.php',
    'ezcDocumentOdtStyleGenerator'                       => 'Document/converters/element_visitor/docbook/odt/styler/pcss/generator.php',
    'ezcDocumentOdtStylePropertyGenerator'               => 'Document/converters/element_visitor/docbook/odt/styler/pcss/property_generator.php',
    'ezcDocumentOdtStyler'                               => 'Document/converters/element_visitor/docbook/odt/styler.php',
    'ezcDocumentParser'                                  => 'Document/interfaces/parser.php',
    'ezcDocumentPcssDirective'                           => 'Document/pcss/directive.php',
    'ezcDocumentPcssStyleBoxValue'                       => 'Document/pcss/style/box_value.php',
    'ezcDocumentPdfDriver'                               => 'Document/document/pdf/driver.php',
    'ezcDocumentPdfFooterPdfPart'                        => 'Document/document/pdf/part/footer.php',
    'ezcDocumentPdfHyphenator'                           => 'Document/document/pdf/hyphenator.php',
    'ezcDocumentPdfImageHandler'                         => 'Document/document/pdf/image/handler.php',
    'ezcDocumentPdfMainRenderer'                         => 'Document/document/pdf/renderer/main.php',
    'ezcDocumentPdfTableColumnWidthCalculator'           => 'Document/document/pdf/table_column_width_calculator.php',
    'ezcDocumentPdfTokenizer'                            => 'Document/document/pdf/tokenizer.php',
    'ezcDocumentPdfWrappingTextBoxRenderer'              => 'Document/document/pdf/renderer/paragraph.php',
    'ezcDocumentRstBlockNode'                            => 'Document/document/rst/nodes/block.php',
    'ezcDocumentRstImageDirective'                       => 'Document/document/rst/directive/image.php',
    'ezcDocumentRstLinkNode'                             => 'Document/document/rst/nodes/link.php',
    'ezcDocumentRstMarkupNode'                           => 'Document/document/rst/nodes/markup.php',
    'ezcDocumentRstTextRole'                             => 'Document/document/rst/role.php',
    'ezcDocumentRstXhtmlTextRole'                        => 'Document/interfaces/rst_xhtml_role.php',
    'ezcDocumentRstXhtmlVisitor'                         => 'Document/document/rst/visitor/xhtml.php',
    'ezcDocumentWiki'                                    => 'Document/document/wiki.php',
    'ezcDocumentWikiLineLevelNode'                       => 'Document/document/wiki/nodes/line.php',
    'ezcDocumentWikiLineMarkupToken'                     => 'Document/document/wiki/token/line_markup.php',
    'ezcDocumentWikiLinkStartToken'                      => 'Document/document/wiki/token/link_start.php',
    'ezcDocumentWikiListNode'                            => 'Document/document/wiki/nodes/list.php',
    'ezcDocumentWikiMatchingInlineNode'                  => 'Document/document/wiki/nodes/matching_inline.php',
    'ezcDocumentWikiPlugin'                              => 'Document/document/wiki/plugin.php',
    'ezcDocumentWikiSectionNode'                         => 'Document/document/wiki/nodes/section.php',
    'ezcDocumentWikiSeparatorNode'                       => 'Document/document/wiki/nodes/separator.php',
    'ezcDocumentWikiTokenizer'                           => 'Document/document/wiki/tokenizer.php',
    'ezcDocumentWikiVisitor'                             => 'Document/document/wiki/visitor.php',
    'ezcDocumentXhtmlBaseFilter'                         => 'Document/document/xml/xhtml/filter/base.php',
    'ezcDocumentXhtmlConversion'                         => 'Document/interfaces/conversions/xhtml.php',
    'ezcDocumentXhtmlElementBaseFilter'                  => 'Document/document/xml/xhtml/filter/element/base.php',
    'ezcDocumentXmlBase'                                 => 'Document/document/xml_base.php',
    'ezcDocumentXmlOptions'                              => 'Document/options/document_xml.php',
    'ezcDocumentXsltConverter'                           => 'Document/converters/xslt.php',
    'ezcDocumentXsltConverterOptions'                    => 'Document/options/converter_xslt.php',
    'ezcDocumentAlphaListItemGenerator'                  => 'Document/document/pdf/item_generator/alpha.php',
    'ezcDocumentBBCode'                                  => 'Document/document/bbcode.php',
    'ezcDocumentBBCodeBulletListNode'                    => 'Document/document/bbcode/nodes/bullet_list.php',
    'ezcDocumentBBCodeClosingTagNode'                    => 'Document/document/bbcode/nodes/tag_close.php',
    'ezcDocumentBBCodeDocbookVisitor'                    => 'Document/document/bbcode/visitor/docbook.php',
    'ezcDocumentBBCodeDocumentNode'                      => 'Document/document/bbcode/nodes/document.php',
    'ezcDocumentBBCodeEmailPlugin'                       => 'Document/document/bbcode/plugins/email.php',
    'ezcDocumentBBCodeEmphasisPlugin'                    => 'Document/document/bbcode/plugins/emphasis.php',
    'ezcDocumentBBCodeEndOfFileToken'                    => 'Document/document/bbcode/token/end_of_file.php',
    'ezcDocumentBBCodeEnumeratedListNode'                => 'Document/document/bbcode/nodes/enumerated_list.php',
    'ezcDocumentBBCodeImagePlugin'                       => 'Document/document/bbcode/plugins/image.php',
    'ezcDocumentBBCodeInlineLiteralNode'                 => 'Document/document/bbcode/nodes/inline_literal.php',
    'ezcDocumentBBCodeLineBreakToken'                    => 'Document/document/bbcode/token/line_break.php',
    'ezcDocumentBBCodeListEndNode'                       => 'Document/document/bbcode/nodes/list_end.php',
    'ezcDocumentBBCodeListItemNode'                      => 'Document/document/bbcode/nodes/list_item.php',
    'ezcDocumentBBCodeListItemToken'                     => 'Document/document/bbcode/token/list_item.php',
    'ezcDocumentBBCodeLiteralBlockNode'                  => 'Document/document/bbcode/nodes/literal_block.php',
    'ezcDocumentBBCodeLiteralBlockToken'                 => 'Document/document/bbcode/token/literal_block.php',
    'ezcDocumentBBCodeNewLineToken'                      => 'Document/document/bbcode/token/new_line.php',
    'ezcDocumentBBCodeNoMarkupPlugin'                    => 'Document/document/bbcode/plugins/no.php',
    'ezcDocumentBBCodeOptions'                           => 'Document/options/document_bbcode.php',
    'ezcDocumentBBCodeParagraphNode'                     => 'Document/document/bbcode/nodes/paragraph.php',
    'ezcDocumentBBCodeParser'                            => 'Document/document/bbcode/parser.php',
    'ezcDocumentBBCodeQuotePlugin'                       => 'Document/document/bbcode/plugins/quote.php',
    'ezcDocumentBBCodeSpecialCharsToken'                 => 'Document/document/bbcode/token/special_chars.php',
    'ezcDocumentBBCodeTagCloseToken'                     => 'Document/document/bbcode/token/tag_clsoe.php',
    'ezcDocumentBBCodeTagNode'                           => 'Document/document/bbcode/nodes/tag.php',
    'ezcDocumentBBCodeTagOpenToken'                      => 'Document/document/bbcode/token/tag_open.php',
    'ezcDocumentBBCodeTextLineToken'                     => 'Document/document/bbcode/token/text_line.php',
    'ezcDocumentBBCodeTextNode'                          => 'Document/document/bbcode/nodes/text.php',
    'ezcDocumentBBCodeTokenizer'                         => 'Document/document/bbcode/tokenizer.php',
    'ezcDocumentBBCodeUrlPlugin'                         => 'Document/document/bbcode/plugins/url.php',
    'ezcDocumentBBCodeWhitespaceToken'                   => 'Document/document/bbcode/token/whitespace.php',
    'ezcDocumentBulletListItemGenerator'                 => 'Document/document/pdf/item_generator/bullet.php',
    'ezcDocumentConfluenceWiki'                          => 'Document/document/wiki/confluence.php',
    'ezcDocumentCreoleWiki'                              => 'Document/document/wiki/creole.php',
    'ezcDocumentDocbook'                                 => 'Document/document/xml/docbook.php',
    'ezcDocumentDocbookOptions'                          => 'Document/options/document_docbook.php',
    'ezcDocumentDocbookToEzXmlAnchorHandler'             => 'Document/converters/element_visitor/docbook/ezxml/anchor.php',
    'ezcDocumentDocbookToEzXmlCommentHandler'            => 'Document/converters/element_visitor/docbook/ezxml/comment.php',
    'ezcDocumentDocbookToEzXmlConverter'                 => 'Document/converters/element_visitor/docbook_ezxml.php',
    'ezcDocumentDocbookToEzXmlConverterOptions'          => 'Document/options/converter_docbook_ezxml.php',
    'ezcDocumentDocbookToEzXmlEmphasisHandler'           => 'Document/converters/element_visitor/docbook/ezxml/emphasis.php',
    'ezcDocumentDocbookToEzXmlExternalLinkHandler'       => 'Document/converters/element_visitor/docbook/ezxml/external_link.php',
    'ezcDocumentDocbookToEzXmlFootnoteHandler'           => 'Document/converters/element_visitor/docbook/ezxml/footnote.php',
    'ezcDocumentDocbookToEzXmlIgnoreHandler'             => 'Document/converters/element_visitor/docbook/ezxml/ignore.php',
    'ezcDocumentDocbookToEzXmlInternalLinkHandler'       => 'Document/converters/element_visitor/docbook/ezxml/internal_link.php',
    'ezcDocumentDocbookToEzXmlItemizedListHandler'       => 'Document/converters/element_visitor/docbook/ezxml/itemized_list.php',
    'ezcDocumentDocbookToEzXmlLiteralLayoutHandler'      => 'Document/converters/element_visitor/docbook/ezxml/literal_layout.php',
    'ezcDocumentDocbookToEzXmlMappingHandler'            => 'Document/converters/element_visitor/docbook/ezxml/mapper.php',
    'ezcDocumentDocbookToEzXmlOrderedListHandler'        => 'Document/converters/element_visitor/docbook/ezxml/ordered_list.php',
    'ezcDocumentDocbookToEzXmlParagraphHandler'          => 'Document/converters/element_visitor/docbook/ezxml/paragraph.php',
    'ezcDocumentDocbookToEzXmlRecurseHandler'            => 'Document/converters/element_visitor/docbook/ezxml/recurse.php',
    'ezcDocumentDocbookToEzXmlSectionHandler'            => 'Document/converters/element_visitor/docbook/ezxml/section.php',
    'ezcDocumentDocbookToEzXmlTableCellHandler'          => 'Document/converters/element_visitor/docbook/ezxml/table_cell.php',
    'ezcDocumentDocbookToEzXmlTableHandler'              => 'Document/converters/element_visitor/docbook/ezxml/table.php',
    'ezcDocumentDocbookToEzXmlTitleHandler'              => 'Document/converters/element_visitor/docbook/ezxml/title.php',
    'ezcDocumentDocbookToHtmlAnchorHandler'              => 'Document/converters/element_visitor/docbook/xhtml/anchor.php',
    'ezcDocumentDocbookToHtmlBlockquoteHandler'          => 'Document/converters/element_visitor/docbook/xhtml/blockquote.php',
    'ezcDocumentDocbookToHtmlCommentHandler'             => 'Document/converters/element_visitor/docbook/xhtml/comment.php',
    'ezcDocumentDocbookToHtmlConverter'                  => 'Document/converters/element_visitor/docbook_html.php',
    'ezcDocumentDocbookToHtmlConverterOptions'           => 'Document/options/converter_docbook_html.php',
    'ezcDocumentDocbookToHtmlDefinitionListEntryHandler' => 'Document/converters/element_visitor/docbook/xhtml/definition_list_entry.php',
    'ezcDocumentDocbookToHtmlEmphasisHandler'            => 'Document/converters/element_visitor/docbook/xhtml/emphasis.php',
    'ezcDocumentDocbookToHtmlExternalLinkHandler'        => 'Document/converters/element_visitor/docbook/xhtml/external_link.php',
    'ezcDocumentDocbookToHtmlFootnoteHandler'            => 'Document/converters/element_visitor/docbook/xhtml/footnote.php',
    'ezcDocumentDocbookToHtmlHeadHandler'                => 'Document/converters/element_visitor/docbook/xhtml/head.php',
    'ezcDocumentDocbookToHtmlIgnoreHandler'              => 'Document/converters/element_visitor/docbook/xhtml/ignore.php',
    'ezcDocumentDocbookToHtmlInternalLinkHandler'        => 'Document/converters/element_visitor/docbook/xhtml/internal_link.php',
    'ezcDocumentDocbookToHtmlLiteralLayoutHandler'       => 'Document/converters/element_visitor/docbook/xhtml/literal_layout.php',
    'ezcDocumentDocbookToHtmlMappingHandler'             => 'Document/converters/element_visitor/docbook/xhtml/mapper.php',
    'ezcDocumentDocbookToHtmlMediaObjectHandler'         => 'Document/converters/element_visitor/docbook/xhtml/mediaobject.php',
    'ezcDocumentDocbookToHtmlParagraphHandler'           => 'Document/converters/element_visitor/docbook/xhtml/paragraph.php',
    'ezcDocumentDocbookToHtmlSectionHandler'             => 'Document/converters/element_visitor/docbook/xhtml/section.php',
    'ezcDocumentDocbookToHtmlSpecialParagraphHandler'    => 'Document/converters/element_visitor/docbook/xhtml/special_paragraph.php',
    'ezcDocumentDocbookToHtmlTableCellHandler'           => 'Document/converters/element_visitor/docbook/xhtml/table_cell.php',
    'ezcDocumentDocbookToHtmlXsltConverter'              => 'Document/converters/xslt/docbook_html.php',
    'ezcDocumentDocbookToHtmlXsltConverterOptions'       => 'Document/options/converter_docbook_html_xslt.php',
    'ezcDocumentDocbookToOdtAnchorHandler'               => 'Document/converters/element_visitor/docbook/odt/element_handlers/anchor.php',
    'ezcDocumentDocbookToOdtCommentHandler'              => 'Document/converters/element_visitor/docbook/odt/element_handlers/comment.php',
    'ezcDocumentDocbookToOdtConverter'                   => 'Document/converters/element_visitor/docbook_odt.php',
    'ezcDocumentDocbookToOdtConverterOptions'            => 'Document/options/converter_docbook_odt.php',
    'ezcDocumentDocbookToOdtFootnoteHandler'             => 'Document/converters/element_visitor/docbook/odt/element_handlers/footnote.php',
    'ezcDocumentDocbookToOdtIgnoreHandler'               => 'Document/converters/element_visitor/docbook/odt/element_handlers/ignore.php',
    'ezcDocumentDocbookToOdtInlineHandler'               => 'Document/converters/element_visitor/docbook/odt/element_handlers/inline.php',
    'ezcDocumentDocbookToOdtLinkHandler'                 => 'Document/converters/element_visitor/docbook/odt/element_handlers/link.php',
    'ezcDocumentDocbookToOdtListHandler'                 => 'Document/converters/element_visitor/docbook/odt/element_handlers/list.php',
    'ezcDocumentDocbookToOdtLiteralLayoutHandler'        => 'Document/converters/element_visitor/docbook/odt/element_handlers/literal_layout.php',
    'ezcDocumentDocbookToOdtMappingHandler'              => 'Document/converters/element_visitor/docbook/odt/element_handlers/mapper.php',
    'ezcDocumentDocbookToOdtMediaObjectHandler'          => 'Document/converters/element_visitor/docbook/odt/element_handlers/media_object.php',
    'ezcDocumentDocbookToOdtPageBreakHandler'            => 'Document/converters/element_visitor/docbook/odt/element_handlers/page_break.php',
    'ezcDocumentDocbookToOdtParagraphHandler'            => 'Document/converters/element_visitor/docbook/odt/element_handlers/paragraph.php',
    'ezcDocumentDocbookToOdtSectionHandler'              => 'Document/converters/element_visitor/docbook/odt/element_handlers/section.php',
    'ezcDocumentDocbookToOdtTableHandler'                => 'Document/converters/element_visitor/docbook/odt/element_handlers/table.php',
    'ezcDocumentDocbookToOdtUlinkHandler'                => 'Document/converters/element_visitor/docbook/odt/element_handlers/ulink.php',
    'ezcDocumentDocbookToRstBeginPageHandler'            => 'Document/converters/element_visitor/docbook/rst/begin_page.php',
    'ezcDocumentDocbookToRstBlockquoteHandler'           => 'Document/converters/element_visitor/docbook/rst/blockquote.php',
    'ezcDocumentDocbookToRstCitationHandler'             => 'Document/converters/element_visitor/docbook/rst/citation.php',
    'ezcDocumentDocbookToRstCommentHandler'              => 'Document/converters/element_visitor/docbook/rst/comment.php',
    'ezcDocumentDocbookToRstConverter'                   => 'Document/converters/element_visitor/docbook_rst.php',
    'ezcDocumentDocbookToRstConverterOptions'            => 'Document/options/converter_docbook_rst.php',
    'ezcDocumentDocbookToRstEmphasisHandler'             => 'Document/converters/element_visitor/docbook/rst/emphasis.php',
    'ezcDocumentDocbookToRstExternalLinkHandler'         => 'Document/converters/element_visitor/docbook/rst/external_link.php',
    'ezcDocumentDocbookToRstFootnoteHandler'             => 'Document/converters/element_visitor/docbook/rst/footnote.php',
    'ezcDocumentDocbookToRstHeadHandler'                 => 'Document/converters/element_visitor/docbook/rst/head.php',
    'ezcDocumentDocbookToRstIgnoreHandler'               => 'Document/converters/element_visitor/docbook/rst/ignore.php',
    'ezcDocumentDocbookToRstInlineMediaObjectHandler'    => 'Document/converters/element_visitor/docbook/rst/inlinemediaobject.php',
    'ezcDocumentDocbookToRstInternalLinkHandler'         => 'Document/converters/element_visitor/docbook/rst/internal_link.php',
    'ezcDocumentDocbookToRstItemizedListHandler'         => 'Document/converters/element_visitor/docbook/rst/itemized_list.php',
    'ezcDocumentDocbookToRstLiteralHandler'              => 'Document/converters/element_visitor/docbook/rst/literal.php',
    'ezcDocumentDocbookToRstLiteralLayoutHandler'        => 'Document/converters/element_visitor/docbook/rst/literal_layout.php',
    'ezcDocumentDocbookToRstOrderedListHandler'          => 'Document/converters/element_visitor/docbook/rst/ordered_list.php',
    'ezcDocumentDocbookToRstParagraphHandler'            => 'Document/converters/element_visitor/docbook/rst/paragraph.php',
    'ezcDocumentDocbookToRstRecurseHandler'              => 'Document/converters/element_visitor/docbook/rst/recurse.php',
    'ezcDocumentDocbookToRstSectionHandler'              => 'Document/converters/element_visitor/docbook/rst/section.php',
    'ezcDocumentDocbookToRstSpecialParagraphHandler'     => 'Document/converters/element_visitor/docbook/rst/special_paragraph.php',
    'ezcDocumentDocbookToRstTableHandler'                => 'Document/converters/element_visitor/docbook/rst/table.php',
    'ezcDocumentDocbookToRstVariableListHandler'         => 'Document/converters/element_visitor/docbook/rst/variable_list.php',
    'ezcDocumentDocbookToWikiBeginPageHandler'           => 'Document/converters/element_visitor/docbook/wiki/begin_page.php',
    'ezcDocumentDocbookToWikiConverter'                  => 'Document/converters/element_visitor/docbook_wiki.php',
    'ezcDocumentDocbookToWikiConverterOptions'           => 'Document/options/converter_docbook_wiki.php',
    'ezcDocumentDocbookToWikiEmphasisHandler'            => 'Document/converters/element_visitor/docbook/wiki/emphasis.php',
    'ezcDocumentDocbookToWikiExternalLinkHandler'        => 'Document/converters/element_visitor/docbook/wiki/external_link.php',
    'ezcDocumentDocbookToWikiIgnoreHandler'              => 'Document/converters/element_visitor/docbook/wiki/ignore.php',
    'ezcDocumentDocbookToWikiInlineMediaObjectHandler'   => 'Document/converters/element_visitor/docbook/wiki/inlinemediaobject.php',
    'ezcDocumentDocbookToWikiInternalLinkHandler'        => 'Document/converters/element_visitor/docbook/wiki/internal_link.php',
    'ezcDocumentDocbookToWikiItemizedListHandler'        => 'Document/converters/element_visitor/docbook/wiki/itemized_list.php',
    'ezcDocumentDocbookToWikiLiteralHandler'             => 'Document/converters/element_visitor/docbook/wiki/literal.php',
    'ezcDocumentDocbookToWikiLiteralLayoutHandler'       => 'Document/converters/element_visitor/docbook/wiki/literal_layout.php',
    'ezcDocumentDocbookToWikiOrderedListHandler'         => 'Document/converters/element_visitor/docbook/wiki/ordered_list.php',
    'ezcDocumentDocbookToWikiParagraphHandler'           => 'Document/converters/element_visitor/docbook/wiki/paragraph.php',
    'ezcDocumentDocbookToWikiRecurseHandler'             => 'Document/converters/element_visitor/docbook/wiki/recurse.php',
    'ezcDocumentDocbookToWikiSectionHandler'             => 'Document/converters/element_visitor/docbook/wiki/section.php',
    'ezcDocumentDocbookToWikiTableHandler'               => 'Document/converters/element_visitor/docbook/wiki/table.php',
    'ezcDocumentDokuwikiWiki'                            => 'Document/document/wiki/dokuwiki.php',
    'ezcDocumentEzXml'                                   => 'Document/document/xml/ezxml.php',
    'ezcDocumentEzXmlDummyLinkConverter'                 => 'Document/document/xml/ezxml/dummy_link_converter.php',
    'ezcDocumentEzXmlDummyLinkProvider'                  => 'Document/document/xml/ezxml/dummy_link_provider.php',
    'ezcDocumentEzXmlOptions'                            => 'Document/options/document_ezxml.php',
    'ezcDocumentEzXmlToDocbookAnchorHandler'             => 'Document/converters/element_visitor/ezxml/docbook/anchor.php',
    'ezcDocumentEzXmlToDocbookConverter'                 => 'Document/converters/element_visitor/ezxml_docbook.php',
    'ezcDocumentEzXmlToDocbookConverterOptions'          => 'Document/options/converter_ezxml_docbook.php',
    'ezcDocumentEzXmlToDocbookEmphasisHandler'           => 'Document/converters/element_visitor/ezxml/docbook/emphasis.php',
    'ezcDocumentEzXmlToDocbookHeaderHandler'             => 'Document/converters/element_visitor/ezxml/docbook/header.php',
    'ezcDocumentEzXmlToDocbookLineHandler'               => 'Document/converters/element_visitor/ezxml/docbook/line.php',
    'ezcDocumentEzXmlToDocbookLinkHandler'               => 'Document/converters/element_visitor/ezxml/docbook/link.php',
    'ezcDocumentEzXmlToDocbookListHandler'               => 'Document/converters/element_visitor/ezxml/docbook/list.php',
    'ezcDocumentEzXmlToDocbookLiteralHandler'            => 'Document/converters/element_visitor/ezxml/docbook/literal.php',
    'ezcDocumentEzXmlToDocbookMappingHandler'            => 'Document/converters/element_visitor/ezxml/docbook/mapper.php',
    'ezcDocumentEzXmlToDocbookTableCellHandler'          => 'Document/converters/element_visitor/ezxml/docbook/table_cell.php',
    'ezcDocumentEzXmlToDocbookTableHandler'              => 'Document/converters/element_visitor/ezxml/docbook/table.php',
    'ezcDocumentEzXmlToDocbookTableRowHandler'           => 'Document/converters/element_visitor/ezxml/docbook/table_row.php',
    'ezcDocumentListBulletGuesser'                       => 'Document/tools/list_bullet_guesser.php',
    'ezcDocumentLocateableDomElement'                    => 'Document/dom_elements/locateable.php',
    'ezcDocumentNoListItemGenerator'                     => 'Document/document/pdf/item_generator/no.php',
    'ezcDocumentNumberedListItemGenerator'               => 'Document/document/pdf/item_generator/number.php',
    'ezcDocumentOdt'                                     => 'Document/document/xml/odt.php',
    'ezcDocumentOdtDefaultPcssConverter'                 => 'Document/converters/element_visitor/docbook/odt/styler/pcss/converter/default.php',
    'ezcDocumentOdtElementFilter'                        => 'Document/document/xml/odt/filter/element.php',
    'ezcDocumentOdtElementFootnoteFilter'                => 'Document/document/xml/odt/filter/element/footnote.php',
    'ezcDocumentOdtElementFrameFilter'                   => 'Document/document/xml/odt/filter/element/frame.php',
    'ezcDocumentOdtElementHeaderFilter'                  => 'Document/document/xml/odt/filter/element/header.php',
    'ezcDocumentOdtElementHtmlTableFilter'               => 'Document/document/xml/odt/filter/element/html_table.php',
    'ezcDocumentOdtElementImageFilter'                   => 'Document/document/xml/odt/filter/element/image.php',
    'ezcDocumentOdtElementLinkFilter'                    => 'Document/document/xml/odt/filter/element/link.php',
    'ezcDocumentOdtElementListFilter'                    => 'Document/document/xml/odt/filter/element/list.php',
    'ezcDocumentOdtElementParagraphFilter'               => 'Document/document/xml/odt/filter/element/paragraph.php',
    'ezcDocumentOdtElementTableFilter'                   => 'Document/document/xml/odt/filter/element/table.php',
    'ezcDocumentOdtElementWhitespaceFilter'              => 'Document/document/xml/odt/filter/element/whitespace.php',
    'ezcDocumentOdtEmphasisStyleFilterRule'              => 'Document/document/xml/odt/filter/style/rule/emphasis.php',
    'ezcDocumentOdtFormattingProperties'                 => 'Document/document/xml/odt/formatting/properties.php',
    'ezcDocumentOdtFormattingPropertyCollection'         => 'Document/document/xml/odt/formatting/property_collection.php',
    'ezcDocumentOdtImageFilter'                          => 'Document/document/xml/odt/filter/image.php',
    'ezcDocumentOdtImageLocator'                         => 'Document/converters/element_visitor/docbook/odt/image_locator.php',
    'ezcDocumentOdtListLevelStyleBullet'                 => 'Document/document/xml/odt/list_level_style/bullet.php',
    'ezcDocumentOdtListLevelStyleFilterRule'             => 'Document/document/xml/odt/filter/style/rule/list_level.php',
    'ezcDocumentOdtListLevelStyleNumber'                 => 'Document/document/xml/odt/list_level_style/number.php',
    'ezcDocumentOdtListStyle'                            => 'Document/document/xml/odt/list_style.php',
    'ezcDocumentOdtListStyleGenerator'                   => 'Document/converters/element_visitor/docbook/odt/styler/pcss/generator/list.php',
    'ezcDocumentOdtMetaGenerator'                        => 'Document/converters/element_visitor/docbook/odt/meta_generator.php',
    'ezcDocumentOdtOptions'                              => 'Document/options/document_odt.php',
    'ezcDocumentOdtParagraphStyleGenerator'              => 'Document/converters/element_visitor/docbook/odt/styler/pcss/generator/paragraph.php',
    'ezcDocumentOdtPcssBorderConverter'                  => 'Document/converters/element_visitor/docbook/odt/styler/pcss/converter/border.php',
    'ezcDocumentOdtPcssColorConverter'                   => 'Document/converters/element_visitor/docbook/odt/styler/pcss/converter/color.php',
    'ezcDocumentOdtPcssConverterManager'                 => 'Document/converters/element_visitor/docbook/odt/styler/pcss/converter_manager.php',
    'ezcDocumentOdtPcssConverterTools'                   => 'Document/converters/element_visitor/docbook/odt/styler/pcss/converter_tools.php',
    'ezcDocumentOdtPcssFontConverter'                    => 'Document/converters/element_visitor/docbook/odt/styler/pcss/converter/font.php',
    'ezcDocumentOdtPcssFontNameConverter'                => 'Document/converters/element_visitor/docbook/odt/styler/pcss/converter/font_name.php',
    'ezcDocumentOdtPcssFontSizeConverter'                => 'Document/converters/element_visitor/docbook/odt/styler/pcss/converter/font_size.php',
    'ezcDocumentOdtPcssFontStylePreprocessor'            => 'Document/converters/element_visitor/docbook/odt/styler/pcss/preprocessor/font.php',
    'ezcDocumentOdtPcssListStylePreprocessor'            => 'Document/converters/element_visitor/docbook/odt/styler/pcss/preprocessor/list.php',
    'ezcDocumentOdtPcssMarginConverter'                  => 'Document/converters/element_visitor/docbook/odt/styler/pcss/converter/margin.php',
    'ezcDocumentOdtPcssParagraphStylePreprocessor'       => 'Document/converters/element_visitor/docbook/odt/styler/pcss/preprocessor/paragraph.php',
    'ezcDocumentOdtPcssPreprocessor'                     => 'Document/converters/element_visitor/docbook/odt/styler/pcss/preprocessor.php',
    'ezcDocumentOdtPcssStyler'                           => 'Document/converters/element_visitor/docbook/odt/styler/pcss.php',
    'ezcDocumentOdtPcssTextDecorationConverter'          => 'Document/converters/element_visitor/docbook/odt/styler/pcss/converter/text_decoration.php',
    'ezcDocumentOdtStyle'                                => 'Document/document/xml/odt/style.php',
    'ezcDocumentOdtStyleExtractor'                       => 'Document/document/xml/odt/style/extractor.php',
    'ezcDocumentOdtStyleFilter'                          => 'Document/document/xml/odt/filter/style.php',
    'ezcDocumentOdtStyleInferencer'                      => 'Document/document/xml/odt/style/inferencer.php',
    'ezcDocumentOdtStyleInformation'                     => 'Document/converters/element_visitor/docbook/odt/style_information.php',
    'ezcDocumentOdtStyleListPropertyGenerator'           => 'Document/converters/element_visitor/docbook/odt/styler/pcss/property_generator/list.php',
    'ezcDocumentOdtStyleParagraphPropertyGenerator'      => 'Document/converters/element_visitor/docbook/odt/styler/pcss/property_generator/paragraph.php',
    'ezcDocumentOdtStyleParser'                          => 'Document/document/xml/odt/style/parser.php',
    'ezcDocumentOdtStyleTableCellPropertyGenerator'      => 'Document/converters/element_visitor/docbook/odt/styler/pcss/property_generator/table_cell.php',
    'ezcDocumentOdtStyleTablePropertyGenerator'          => 'Document/converters/element_visitor/docbook/odt/styler/pcss/property_generator/table.php',
    'ezcDocumentOdtStyleTableRowPropertyGenerator'       => 'Document/converters/element_visitor/docbook/odt/styler/pcss/property_generator/table_row.php',
    'ezcDocumentOdtStyleTextPropertyGenerator'           => 'Document/converters/element_visitor/docbook/odt/styler/pcss/property_generator/text.php',
    'ezcDocumentOdtTableCellStyleGenerator'              => 'Document/converters/element_visitor/docbook/odt/styler/pcss/generator/table_cell.php',
    'ezcDocumentOdtTableRowStyleGenerator'               => 'Document/converters/element_visitor/docbook/odt/styler/pcss/generator/table_row.php',
    'ezcDocumentOdtTableStyleGenerator'                  => 'Document/converters/element_visitor/docbook/odt/styler/pcss/generator/table.php',
    'ezcDocumentOdtTextProcessor'                        => 'Document/converters/element_visitor/docbook/odt/text_processor.php',
    'ezcDocumentOdtTextStyleGenerator'                   => 'Document/converters/element_visitor/docbook/odt/styler/pcss/generator/text.php',
    'ezcDocumentParserOptions'                           => 'Document/options/document_parser.php',
    'ezcDocumentPcssDeclarationDirective'                => 'Document/pcss/declaration_directive.php',
    'ezcDocumentPcssLayoutDirective'                     => 'Document/pcss/layout_directive.php',
    'ezcDocumentPcssMeasure'                             => 'Document/pcss/measure.php',
    'ezcDocumentPcssParser'                              => 'Document/pcss/parser.php',
    'ezcDocumentPcssStyleBorderBoxValue'                 => 'Document/pcss/style/border_box_value.php',
    'ezcDocumentPcssStyleBorderValue'                    => 'Document/pcss/style/border_value.php',
    'ezcDocumentPcssStyleColorBoxValue'                  => 'Document/pcss/style/color_box_value.php',
    'ezcDocumentPcssStyleColorValue'                     => 'Document/pcss/style/color_value.php',
    'ezcDocumentPcssStyleInferencer'                     => 'Document/pcss/style_inferencer.php',
    'ezcDocumentPcssStyleIntValue'                       => 'Document/pcss/style/int_value.php',
    'ezcDocumentPcssStyleLineBoxValue'                   => 'Document/pcss/style/line_box_value.php',
    'ezcDocumentPcssStyleLineValue'                      => 'Document/pcss/style/line_value.php',
    'ezcDocumentPcssStyleListValue'                      => 'Document/pcss/style/list_value.php',
    'ezcDocumentPcssStyleMeasureBoxValue'                => 'Document/pcss/style/measure_box_value.php',
    'ezcDocumentPcssStyleMeasureValue'                   => 'Document/pcss/style/measure_value.php',
    'ezcDocumentPcssStyleSrcValue'                       => 'Document/pcss/style/src_value.php',
    'ezcDocumentPcssStyleStringValue'                    => 'Document/pcss/style/string_value.php',
    'ezcDocumentPdf'                                     => 'Document/document/pdf.php',
    'ezcDocumentPdfBlockquoteRenderer'                   => 'Document/document/pdf/renderer/blockquote.php',
    'ezcDocumentPdfBoundingBox'                          => 'Document/document/pdf/box.php',
    'ezcDocumentPdfDefaultHyphenator'                    => 'Document/document/pdf/hyphenator/default.php',
    'ezcDocumentPdfDefaultTableColumnWidthCalculator'    => 'Document/document/pdf/default_table_column_width_calculator.php',
    'ezcDocumentPdfDefaultTokenizer'                     => 'Document/document/pdf/tokenizer/default.php',
    'ezcDocumentPdfFooterOptions'                        => 'Document/options/document_pdf_footer.php',
    'ezcDocumentPdfHaruDriver'                           => 'Document/document/pdf/driver/haru.php',
    'ezcDocumentPdfHeaderPdfPart'                        => 'Document/document/pdf/part/header.php',
    'ezcDocumentPdfImage'                                => 'Document/document/pdf/image.php',
    'ezcDocumentPdfListItemRenderer'                     => 'Document/document/pdf/renderer/list_item.php',
    'ezcDocumentPdfListRenderer'                         => 'Document/document/pdf/renderer/list.php',
    'ezcDocumentPdfLiteralBlockRenderer'                 => 'Document/document/pdf/renderer/literal_block.php',
    'ezcDocumentPdfLiteralTokenizer'                     => 'Document/document/pdf/tokenizer/literal.php',
    'ezcDocumentPdfMediaObjectRenderer'                  => 'Document/document/pdf/renderer/mediaobject.php',
    'ezcDocumentPdfOptions'                              => 'Document/options/document_pdf.php',
    'ezcDocumentPdfPage'                                 => 'Document/document/pdf/page.php',
    'ezcDocumentPdfPhpImageHandler'                      => 'Document/document/pdf/image/php.php',
    'ezcDocumentPdfSvgDriver'                            => 'Document/document/pdf/driver/svg.php',
    'ezcDocumentPdfTableRenderer'                        => 'Document/document/pdf/renderer/table.php',
    'ezcDocumentPdfTcpdfDriver'                          => 'Document/document/pdf/driver/tcpdf.php',
    'ezcDocumentPdfTextBlockRenderer'                    => 'Document/document/pdf/renderer/text_block.php',
    'ezcDocumentPdfTitleRenderer'                        => 'Document/document/pdf/renderer/title.php',
    'ezcDocumentPdfTransactionalDriverWrapper'           => 'Document/document/pdf/driver/wrapper.php',
    'ezcDocumentPdfTransactionalDriverWrapperState'      => 'Document/document/pdf/driver/wrapper_state.php',
    'ezcDocumentPropertyContainerDomElement'             => 'Document/dom_elements/property_container.php',
    'ezcDocumentRomanListItemGenerator'                  => 'Document/document/pdf/item_generator/roman.php',
    'ezcDocumentRst'                                     => 'Document/document/rst.php',
    'ezcDocumentRstAnonymousLinkNode'                    => 'Document/document/rst/nodes/link_anonymous.php',
    'ezcDocumentRstAnonymousReferenceNode'               => 'Document/document/rst/nodes/anon_reference.php',
    'ezcDocumentRstAttentionDirective'                   => 'Document/document/rst/directive/attention.php',
    'ezcDocumentRstBlockquoteAnnotationNode'             => 'Document/document/rst/nodes/blockquote_annotation.php',
    'ezcDocumentRstBlockquoteNode'                       => 'Document/document/rst/nodes/blockquote.php',
    'ezcDocumentRstBulletListListNode'                   => 'Document/document/rst/nodes/bullet_list_list.php',
    'ezcDocumentRstBulletListNode'                       => 'Document/document/rst/nodes/bullet_list.php',
    'ezcDocumentRstCommentNode'                          => 'Document/document/rst/nodes/comment.php',
    'ezcDocumentRstContentsDirective'                    => 'Document/document/rst/directive/contents.php',
    'ezcDocumentRstDangerDirective'                      => 'Document/document/rst/directive/danger.php',
    'ezcDocumentRstDefinitionListListNode'               => 'Document/document/rst/nodes/definition_list_list.php',
    'ezcDocumentRstDefinitionListNode'                   => 'Document/document/rst/nodes/definition_list.php',
    'ezcDocumentRstDirectiveNode'                        => 'Document/document/rst/nodes/directive.php',
    'ezcDocumentRstDocbookVisitor'                       => 'Document/document/rst/visitor/docbook.php',
    'ezcDocumentRstDocumentNode'                         => 'Document/document/rst/nodes/document.php',
    'ezcDocumentRstEmphasisTextRole'                     => 'Document/document/rst/role/emphasis.php',
    'ezcDocumentRstEnumeratedListListNode'               => 'Document/document/rst/nodes/enumerated_list_list.php',
    'ezcDocumentRstEnumeratedListNode'                   => 'Document/document/rst/nodes/enumerated_list.php',
    'ezcDocumentRstExternalReferenceNode'                => 'Document/document/rst/nodes/link_reference.php',
    'ezcDocumentRstFieldListNode'                        => 'Document/document/rst/nodes/field_list.php',
    'ezcDocumentRstFigureDirective'                      => 'Document/document/rst/directive/figure.php',
    'ezcDocumentRstFootnoteNode'                         => 'Document/document/rst/nodes/footnote.php',
    'ezcDocumentRstIncludeDirective'                     => 'Document/document/rst/directive/include.php',
    'ezcDocumentRstLineBlockLineNode'                    => 'Document/document/rst/nodes/line_block_line.php',
    'ezcDocumentRstLineBlockNode'                        => 'Document/document/rst/nodes/line_block.php',
    'ezcDocumentRstLiteralBlockNode'                     => 'Document/document/rst/nodes/literal_block.php',
    'ezcDocumentRstLiteralNode'                          => 'Document/document/rst/nodes/literal.php',
    'ezcDocumentRstLiteralTextRole'                      => 'Document/document/rst/role/literal.php',
    'ezcDocumentRstMarkupEmphasisNode'                   => 'Document/document/rst/nodes/markup_emphasis.php',
    'ezcDocumentRstMarkupInlineLiteralNode'              => 'Document/document/rst/nodes/markup_inline_literal.php',
    'ezcDocumentRstMarkupInterpretedTextNode'            => 'Document/document/rst/nodes/markup_interpreted_text.php',
    'ezcDocumentRstMarkupStrongEmphasisNode'             => 'Document/document/rst/nodes/markup_strong_emphasis.php',
    'ezcDocumentRstMarkupSubstitutionNode'               => 'Document/document/rst/nodes/markup_substitution.php',
    'ezcDocumentRstNamedReferenceNode'                   => 'Document/document/rst/nodes/named_reference.php',
    'ezcDocumentRstNoteDirective'                        => 'Document/document/rst/directive/note.php',
    'ezcDocumentRstNoticeDirective'                      => 'Document/document/rst/directive/notice.php',
    'ezcDocumentRstOptions'                              => 'Document/options/document_rst.php',
    'ezcDocumentRstParagraphNode'                        => 'Document/document/rst/nodes/paragraph.php',
    'ezcDocumentRstParser'                               => 'Document/document/rst/parser.php',
    'ezcDocumentRstReferenceNode'                        => 'Document/document/rst/nodes/reference.php',
    'ezcDocumentRstSectionNode'                          => 'Document/document/rst/nodes/section.php',
    'ezcDocumentRstStack'                                => 'Document/document/rst/document_stack.php',
    'ezcDocumentRstStrongTextRole'                       => 'Document/document/rst/role/strong.php',
    'ezcDocumentRstSubscriptTextRole'                    => 'Document/document/rst/role/subscript.php',
    'ezcDocumentRstSubstitutionNode'                     => 'Document/document/rst/nodes/substitution.php',
    'ezcDocumentRstSuperscriptTextRole'                  => 'Document/document/rst/role/superscript.php',
    'ezcDocumentRstTableBodyNode'                        => 'Document/document/rst/nodes/table_body.php',
    'ezcDocumentRstTableCellNode'                        => 'Document/document/rst/nodes/table_cell.php',
    'ezcDocumentRstTableHeadNode'                        => 'Document/document/rst/nodes/table_head.php',
    'ezcDocumentRstTableNode'                            => 'Document/document/rst/nodes/table.php',
    'ezcDocumentRstTableRowNode'                         => 'Document/document/rst/nodes/table_row.php',
    'ezcDocumentRstTargetNode'                           => 'Document/document/rst/nodes/target.php',
    'ezcDocumentRstTextLineNode'                         => 'Document/document/rst/nodes/text_line.php',
    'ezcDocumentRstTitleNode'                            => 'Document/document/rst/nodes/title.php',
    'ezcDocumentRstTitleReferenceTextRole'               => 'Document/document/rst/role/title_reference.php',
    'ezcDocumentRstToken'                                => 'Document/document/rst/token.php',
    'ezcDocumentRstTokenizer'                            => 'Document/document/rst/tokenizer.php',
    'ezcDocumentRstTransitionNode'                       => 'Document/document/rst/nodes/transition.php',
    'ezcDocumentRstWarningDirective'                     => 'Document/document/rst/directive/warning.php',
    'ezcDocumentRstXhtmlBodyVisitor'                     => 'Document/document/rst/visitor/xhtml_body.php',
    'ezcDocumentValidationError'                         => 'Document/validation_error.php',
    'ezcDocumentWikiBlockquoteNode'                      => 'Document/document/wiki/nodes/blockquote.php',
    'ezcDocumentWikiBoldNode'                            => 'Document/document/wiki/nodes/bold.php',
    'ezcDocumentWikiBoldToken'                           => 'Document/document/wiki/token/bold.php',
    'ezcDocumentWikiBulletListItemNode'                  => 'Document/document/wiki/nodes/bullet_list_item.php',
    'ezcDocumentWikiBulletListItemToken'                 => 'Document/document/wiki/token/bullet_list.php',
    'ezcDocumentWikiBulletListNode'                      => 'Document/document/wiki/nodes/bullet_list.php',
    'ezcDocumentWikiCodePlugin'                          => 'Document/document/wiki/plugin/code.php',
    'ezcDocumentWikiConfluenceLinkStartToken'            => 'Document/document/wiki/token/confluence_link_start.php',
    'ezcDocumentWikiConfluenceTokenizer'                 => 'Document/document/wiki/tokenizer/confluence.php',
    'ezcDocumentWikiCreoleTokenizer'                     => 'Document/document/wiki/tokenizer/creole.php',
    'ezcDocumentWikiDefinitionListItemToken'             => 'Document/document/wiki/token/definition_list.php',
    'ezcDocumentWikiDeletedNode'                         => 'Document/document/wiki/nodes/deleted.php',
    'ezcDocumentWikiDeletedToken'                        => 'Document/document/wiki/token/deleted.php',
    'ezcDocumentWikiDocbookVisitor'                      => 'Document/document/wiki/visitor/docbook.php',
    'ezcDocumentWikiDocumentNode'                        => 'Document/document/wiki/nodes/document.php',
    'ezcDocumentWikiDokuwikiTokenizer'                   => 'Document/document/wiki/tokenizer/dokuwiki.php',
    'ezcDocumentWikiEndOfFileToken'                      => 'Document/document/wiki/token/end_of_file.php',
    'ezcDocumentWikiEnumeratedListItemNode'              => 'Document/document/wiki/nodes/enumerated_list_item.php',
    'ezcDocumentWikiEnumeratedListItemToken'             => 'Document/document/wiki/token/enumerated_list.php',
    'ezcDocumentWikiEnumeratedListNode'                  => 'Document/document/wiki/nodes/enumerated_list.php',
    'ezcDocumentWikiEscapeCharacterToken'                => 'Document/document/wiki/token/escape_character.php',
    'ezcDocumentWikiExternalLinkNode'                    => 'Document/document/wiki/nodes/external_link.php',
    'ezcDocumentWikiExternalLinkToken'                   => 'Document/document/wiki/token/external_link.php',
    'ezcDocumentWikiFootnoteEndNode'                     => 'Document/document/wiki/nodes/footnote_end.php',
    'ezcDocumentWikiFootnoteEndToken'                    => 'Document/document/wiki/token/footnote_end.php',
    'ezcDocumentWikiFootnoteNode'                        => 'Document/document/wiki/nodes/footnote.php',
    'ezcDocumentWikiFootnoteStartToken'                  => 'Document/document/wiki/token/footnote_start.php',
    'ezcDocumentWikiImageEndNode'                        => 'Document/document/wiki/nodes/image_end.php',
    'ezcDocumentWikiImageEndToken'                       => 'Document/document/wiki/token/image_end.php',
    'ezcDocumentWikiImageNode'                           => 'Document/document/wiki/nodes/image.php',
    'ezcDocumentWikiImageStartToken'                     => 'Document/document/wiki/token/image_start.php',
    'ezcDocumentWikiInlineLiteralNode'                   => 'Document/document/wiki/nodes/inline_literal.php',
    'ezcDocumentWikiInlineLiteralToken'                  => 'Document/document/wiki/token/inline_literal.php',
    'ezcDocumentWikiInlineQuoteNode'                     => 'Document/document/wiki/nodes/inline_quote.php',
    'ezcDocumentWikiInlineQuoteToken'                    => 'Document/document/wiki/token/inline_quote.php',
    'ezcDocumentWikiInterWikiLinkNode'                   => 'Document/document/wiki/nodes/inter_wiki_link.php',
    'ezcDocumentWikiInterWikiLinkToken'                  => 'Document/document/wiki/token/inter_wiki_link.php',
    'ezcDocumentWikiInternalLinkNode'                    => 'Document/document/wiki/nodes/internal_link.php',
    'ezcDocumentWikiInternalLinkToken'                   => 'Document/document/wiki/token/internal_link.php',
    'ezcDocumentWikiInvisibleBreakNode'                  => 'Document/document/wiki/nodes/invisible_break.php',
    'ezcDocumentWikiItalicNode'                          => 'Document/document/wiki/nodes/italic.php',
    'ezcDocumentWikiItalicToken'                         => 'Document/document/wiki/token/italic.php',
    'ezcDocumentWikiLineBreakNode'                       => 'Document/document/wiki/nodes/line_break.php',
    'ezcDocumentWikiLineBreakToken'                      => 'Document/document/wiki/token/line_break.php',
    'ezcDocumentWikiLinkEndNode'                         => 'Document/document/wiki/nodes/link_end.php',
    'ezcDocumentWikiLinkEndToken'                        => 'Document/document/wiki/token/link_end.php',
    'ezcDocumentWikiLinkNode'                            => 'Document/document/wiki/nodes/link.php',
    'ezcDocumentWikiLiteralBlockNode'                    => 'Document/document/wiki/nodes/literal_block.php',
    'ezcDocumentWikiLiteralBlockToken'                   => 'Document/document/wiki/token/literal_block.php',
    'ezcDocumentWikiLiteralLineToken'                    => 'Document/document/wiki/token/literal_line.php',
    'ezcDocumentWikiMediawikiEmphasisToken'              => 'Document/document/wiki/token/mediawiki_emphasis.php',
    'ezcDocumentWikiMediawikiTokenizer'                  => 'Document/document/wiki/tokenizer/mediawiki.php',
    'ezcDocumentWikiMonospaceNode'                       => 'Document/document/wiki/nodes/monospace.php',
    'ezcDocumentWikiMonospaceToken'                      => 'Document/document/wiki/token/monospace.php',
    'ezcDocumentWikiNewLineToken'                        => 'Document/document/wiki/token/new_line.php',
    'ezcDocumentWikiOptions'                             => 'Document/options/document_wiki.php',
    'ezcDocumentWikiPageBreakNode'                       => 'Document/document/wiki/nodes/page_break.php',
    'ezcDocumentWikiPageBreakToken'                      => 'Document/document/wiki/token/page_break.php',
    'ezcDocumentWikiParagraphIndentationToken'           => 'Document/document/wiki/token/indentation.php',
    'ezcDocumentWikiParagraphNode'                       => 'Document/document/wiki/nodes/paragraph.php',
    'ezcDocumentWikiParser'                              => 'Document/document/wiki/parser.php',
    'ezcDocumentWikiPluginNode'                          => 'Document/document/wiki/nodes/plugin.php',
    'ezcDocumentWikiPluginToken'                         => 'Document/document/wiki/token/plugin.php',
    'ezcDocumentWikiQuoteToken'                          => 'Document/document/wiki/token/quote.php',
    'ezcDocumentWikiSeparatorToken'                      => 'Document/document/wiki/token/separator.php',
    'ezcDocumentWikiSpecialCharsToken'                   => 'Document/document/wiki/token/special_chars.php',
    'ezcDocumentWikiStrikeToken'                         => 'Document/document/wiki/token/strike.php',
    'ezcDocumentWikiSubscriptNode'                       => 'Document/document/wiki/nodes/subscript.php',
    'ezcDocumentWikiSubscriptToken'                      => 'Document/document/wiki/token/subscript.php',
    'ezcDocumentWikiSuperscriptNode'                     => 'Document/document/wiki/nodes/superscript.php',
    'ezcDocumentWikiSuperscriptToken'                    => 'Document/document/wiki/token/superscript.php',
    'ezcDocumentWikiTableCellNode'                       => 'Document/document/wiki/nodes/table_cell.php',
    'ezcDocumentWikiTableHeaderSeparatorNode'            => 'Document/document/wiki/nodes/table_header_separator.php',
    'ezcDocumentWikiTableHeaderToken'                    => 'Document/document/wiki/token/table_header.php',
    'ezcDocumentWikiTableNode'                           => 'Document/document/wiki/nodes/table.php',
    'ezcDocumentWikiTableRowNode'                        => 'Document/document/wiki/nodes/table_row.php',
    'ezcDocumentWikiTableRowToken'                       => 'Document/document/wiki/token/table_row.php',
    'ezcDocumentWikiTextLineToken'                       => 'Document/document/wiki/token/text_line.php',
    'ezcDocumentWikiTextNode'                            => 'Document/document/wiki/nodes/text.php',
    'ezcDocumentWikiTitleNode'                           => 'Document/document/wiki/nodes/title.php',
    'ezcDocumentWikiTitleToken'                          => 'Document/document/wiki/token/title.php',
    'ezcDocumentWikiUnderlineNode'                       => 'Document/document/wiki/nodes/underline.php',
    'ezcDocumentWikiUnderlineToken'                      => 'Document/document/wiki/token/underline.php',
    'ezcDocumentWikiWhitespaceToken'                     => 'Document/document/wiki/token/whitespace.php',
    'ezcDocumentXhtml'                                   => 'Document/document/xml/xhtml.php',
    'ezcDocumentXhtmlBlockquoteElementFilter'            => 'Document/document/xml/xhtml/filter/element/blockquote.php',
    'ezcDocumentXhtmlContentLocatorFilter'               => 'Document/document/xml/xhtml/filter/content_locator.php',
    'ezcDocumentXhtmlDefinitionListElementFilter'        => 'Document/document/xml/xhtml/filter/element/definitionlist.php',
    'ezcDocumentXhtmlElementFilter'                      => 'Document/document/xml/xhtml/filter/element.php',
    'ezcDocumentXhtmlElementMappingFilter'               => 'Document/document/xml/xhtml/filter/element/mapping.php',
    'ezcDocumentXhtmlEnumeratedElementFilter'            => 'Document/document/xml/xhtml/filter/element/enumerated.php',
    'ezcDocumentXhtmlFootnoteElementFilter'              => 'Document/document/xml/xhtml/filter/element/footnote.php',
    'ezcDocumentXhtmlHeaderElementFilter'                => 'Document/document/xml/xhtml/filter/element/header.php',
    'ezcDocumentXhtmlImageElementFilter'                 => 'Document/document/xml/xhtml/filter/element/image.php',
    'ezcDocumentXhtmlLineBlockElementFilter'             => 'Document/document/xml/xhtml/filter/element/lineblock.php',
    'ezcDocumentXhtmlLinkElementFilter'                  => 'Document/document/xml/xhtml/filter/element/link.php',
    'ezcDocumentXhtmlLiteralElementFilter'               => 'Document/document/xml/xhtml/filter/element/literal.php',
    'ezcDocumentXhtmlMetadataFilter'                     => 'Document/document/xml/xhtml/filter/metadata.php',
    'ezcDocumentXhtmlOptions'                            => 'Document/options/document_xhtml.php',
    'ezcDocumentXhtmlParagraphElementFilter'             => 'Document/document/xml/xhtml/filter/element/paragraph.php',
    'ezcDocumentXhtmlSpecialParagraphElementFilter'      => 'Document/document/xml/xhtml/filter/element/special_paragraph.php',
    'ezcDocumentXhtmlStrongElementFilter'                => 'Document/document/xml/xhtml/filter/element/strong.php',
    'ezcDocumentXhtmlTableCellElementFilter'             => 'Document/document/xml/xhtml/filter/element/tablecell.php',
    'ezcDocumentXhtmlTableElementFilter'                 => 'Document/document/xml/xhtml/filter/element/table.php',
    'ezcDocumentXhtmlTablesFilter'                       => 'Document/document/xml/xhtml/filter/tables.php',
    'ezcDocumentXhtmlTextToParagraphFilter'              => 'Document/document/xml/xhtml/filter/element/text.php',
    'ezcDocumentXhtmlXpathFilter'                        => 'Document/document/xml/xhtml/filter/xpath.php',
);
?>
