<?php
/**
 * File containing the ezcImageAnalyzerFileNotProcessableException.
 * 
 * @package ImageAnalysis
 * @version //autogen//
 * @copyright Copyright (C) 2005-2010 eZ Systems AS. All rights reserved.
 * @license http://ez.no/licenses/new_bsd New BSD License
 */

/**
 * The option name you tried to register is already in use.
 *
 * @package ImageAnalysis
 * @version //autogen//
 */
class ezcImageAnalyzerFileNotProcessableException extends ezcImageAnalyzerException
{
    /**
     * Creates a new ezcImageAnalyzerFileNotProcessableException.
     * 
     * @param string $file   Not processable file.
     * @param string $reason Reason that the file is not processable.
     * @return void
     */
    function __construct( $file, $reason = null )
    {
        $reasonPart = '';
        if ( $reason )
        {
            $reasonPart = " Reason: $reason.";
        }
        parent::__construct( "Could not process file '{$file}'.{$reasonPart}" );
    }
}

?>
