<?php
/**
 * File containing the ezcDocumentRstTitleNode struct
 *
 * @package Document
 * @version //autogen//
 * @copyright Copyright (C) 2005-2010 eZ Systems AS. All rights reserved.
 * @license http://ez.no/licenses/new_bsd New BSD License
 * @access private
 */

/**
 * The document title AST node
 *
 * @package Document
 * @version //autogen//
 * @access private
 */
class ezcDocumentRstTitleNode extends ezcDocumentRstNode
{
    /**
     * Construct RST document node
     *
     * @param ezcDocumentRstToken $token
     * @return void
     */
    public function __construct( ezcDocumentRstToken $token )
    {
        parent::__construct( $token, self::TITLE );
    }

    /**
     * Set state after var_export
     *
     * @param array $properties
     * @return void
     * @ignore
     */
    public static function __set_state( $properties )
    {
        $node = new ezcDocumentRstTitleNode(
            $properties['token']
        );

        $node->nodes = $properties['nodes'];

        return $node;
    }
}

?>
