<?php
/**
 * @copyright Copyright (C) 1999-2012 eZ Systems AS. All rights reserved.
 * @license http://www.gnu.org/licenses/gpl-2.0.txt GNU General Public License v2
 * @version  2012.8
 * @package kernel
 */

$OperationList = array();
$OperationList['read'] = array( 'name' => 'read',
                                'default_call_method' => array( 'include_file' => 'kernel/content/ezcontentoperationcollection.php',
                                                                'class' => 'eZContentOperationCollection' ),
                                'parameter_type' => 'standard',
                                'parameters' => array( array( 'name' => 'node_id',
                                                              'type' => 'integer',
                                                              'required' => true ),
                                                       array( 'name' => 'user_id',
                                                              'type' => 'integer',
                                                              'required' => true ),
                                                       array( 'name' => 'language_code',
                                                              'type' => 'string',
                                                              'default' => '',
                                                              'required' => false ) ),
                                'keys' => array( 'node_id', 'user_id' ),
                                'body' => array( array( 'type' => 'trigger',
                                                        'name' => 'pre_read',
                                                        'keys' => array( 'node_id',
                                                                         'user_id' ) ),
                                                 array( 'type' => 'trigger',
                                                        'name' => 'post_read',
                                                        'keys' => array( 'node_id',
                                                                         'user_id' ) ),
                                                 array( 'type' => 'method',
                                                        'name' => 'fetch-object',
                                                        'frequency' => 'once',
                                                        'method' => 'readObject' ) ) );

$OperationList['publish'] = array( 'name' => 'publish',
                                   'default_call_method' => array( 'include_file' => 'kernel/content/ezcontentoperationcollection.php',
                                                                   'class' => 'eZContentOperationCollection' ),
                                   'parameters' => array( array( 'name' => 'object_id',
                                                                 'type' => 'integer',
                                                                 'required' => true ),
                                                          array( 'name' => 'version',
                                                                 'type' => 'integer',
                                                                 'required' => true ) ),
                                   'body' => array( array( 'type' => 'method',
                                                           'name' => 'set-version-pending',
                                                           'frequency' => 'once',
                                                           'method' => 'setVersionStatus',
                                                           'parameters' => array( array( 'name' => 'object_id',
                                                                                         'type' => 'integer',
                                                                                         'required' => true ),
                                                                                  array( 'name' => 'version',
                                                                                         'type' => 'integer',
                                                                                         'required' => true ),
                                                                                  array( 'name' => 'status',
                                                                                         'type' => 'integer',
                                                                                         'constant' => eZContentObjectVersion::STATUS_PENDING ) ) ),
                                                    array( 'type' => 'method',
                                                           'name' => 'send-to-publishing-queue',
                                                           'frequency' => 'once',
                                                           'method' => 'sendToPublishingQueue',
                                                           'parameters' => array( array( 'name' => 'object_id',
                                                                                         'type' => 'integer',
                                                                                         'required' => true ),
                                                                                  array( 'name' => 'version',
                                                                                         'type' => 'integer',
                                                                                         'required' => true ) ) ),
                                                    array( 'type' => 'method',
                                                           'name' => 'update-section-id',
                                                           'frequency' => 'once',
                                                           'method' => 'updateSectionID'
                                                           ),
                                                    array( 'type' => 'trigger',
                                                           'name' => 'pre_publish',
                                                           'keys' => array( 'object_id',
                                                                            'version' )
                                                           ),
                                                    array( 'type' => 'method',
                                                           'name' => 'copy-translations',
                                                           'frequency' => 'once',
                                                           'method' => 'copyTranslations' ),
                                                    array( 'type' => 'method',
                                                           'name' => 'set-version-archived',
                                                           'frequency' => 'once',
                                                           'method' => 'setVersionStatus',
                                                           'parameters' => array( array( 'name' => 'object_id',
                                                                                         'type' => 'integer',
                                                                                         'required' => true ),
                                                                                  array( 'name' => 'version',
                                                                                         'type' => 'integer',
                                                                                         'constant' => false ), // false means current version
                                                                                  array( 'name' => 'status',
                                                                                         'type' => 'integer',
                                                                                         'constant' => eZContentObjectVersion::STATUS_ARCHIVED ) ) ),
                                                    array( 'type' => 'loop',
                                                           'name' => 'loop-nodes',
                                                           'method' => 'loopNodeAssignment',
                                                           'continue_operation' => 'all',   // 'one', 'none'
                                                           'child_parameters' => array( array( 'name' => 'parent_node_id',
                                                                                               'type' => 'integer',
                                                                                               'required' => true ),
                                                                                        array( 'name' => 'object_id',
                                                                                               'type' => 'integer',
                                                                                               'required' => true ),
                                                                                        array( 'name' => 'version',
                                                                                               'type' => 'integer',
                                                                                               'required' => true ),
                                                                                        array( 'name' => 'main_node_id',
                                                                                               'type' => 'integer',
                                                                                               'required' => true ) ),
                                                           'children' => array( array( 'type' => 'method',
                                                                                       'name' => 'publish-node',
                                                                                       'frequency' => 'always',
                                                                                       'method' => 'publishNode' )
                                                                                ) ),
                                                    array( 'type' => 'method',
                                                           'name' => 'set-version-published',
                                                           'frequency' => 'once',
                                                           'method' => 'setVersionStatus',
                                                           'parameters' => array( array( 'name' => 'object_id',
                                                                                         'type' => 'integer',
                                                                                         'required' => true ),
                                                                                  array( 'name' => 'version',
                                                                                         'type' => 'integer',
                                                                                         'required' => true ),
                                                                                  array( 'name' => 'status',
                                                                                         'type' => 'integer',
                                                                                         'constant' => eZContentObjectVersion::STATUS_PUBLISHED ) ) ),
                                                    array( 'type' => 'method',
                                                           'name' => 'set-object-published',
                                                           'frequency' => 'once',
                                                           'method' => 'setObjectStatusPublished',
                                                           'parameters' => array( array( 'name' => 'object_id',
                                                                                         'type' => 'integer',
                                                                                         'required' => true ),
                                                                                  array( 'name' => 'version',
                                                                                         'type' => 'integer',
                                                                                         'required' => true )
                                                                                  ) ),
                                                    array( 'type' => 'method',
                                                           'name' => 'publish-object-extension-handler',
                                                           'frequency' => 'once',
                                                           'method' => 'publishObjectExtensionHandler',
                                                           'parameters' => array( array( 'name' => 'object_id',
                                                                                         'type' => 'integer',
                                                                                         'required' => true ),
                                                                                  array( 'name' => 'version',
                                                                                         'type' => 'integer',
                                                                                         'required' => true )
                                                                                  ) ),
                                                    array( 'type' => 'method',
                                                           'name' => 'remove-old-nodes',
                                                           'frequency' => 'once',
                                                           'method' => 'removeOldNodes',
                                                           ),
                                                    array( 'type' => 'method',
                                                           'name' => 'attribute-publish-action',
                                                           'frequency' => 'once',
                                                           'method' => 'attributePublishAction',
                                                           'parameters' => array( array( 'name' => 'object_id',
                                                                                         'type' => 'integer',
                                                                                         'required' => true ),
                                                                                  array( 'name' => 'version',
                                                                                         'type' => 'integer',
                                                                                         'required' => true ) ) ),
                                                    array( 'type' => 'method',
                                                           'name' => 'update-nontranslatable-attributes',
                                                           'frequency' => 'once',
                                                           'method' => 'updateNontranslatableAttributes' ),
                                                    array( 'type' => 'method',
                                                           'name' => 'reset-nodeassignment-opcodes',
                                                           'frequency' => 'once',
                                                           'method' => 'resetNodeassignmentOpcodes',
                                                           ),

                                                    array( 'type' => 'method',
                                                           'name' => 'clear-object-view-cache',
                                                           'frequency' => 'once',
                                                           'method' => 'clearObjectViewCache',
                                                           'parameters' => array(  array( 'name' => 'object_id',
                                                                                          'type' => 'integer',
                                                                                          'required' => true ),
                                                                                   array( 'name' => 'version',
                                                                                          'type' => 'integer',
                                                                                          'required' => true ) ) ),
                                                    // PreGeneration: This generates view cache for a given set of users if enabled
                                                    array( 'type' => 'method',
                                                           'name' => 'generate-object-view-cache',
                                                           'frequency' => 'once',
                                                           'method' => 'generateObjectViewCache',
                                                           'parameters' => array(  array( 'name' => 'object_id',
                                                                                          'type' => 'integer',
                                                                                          'required' => true ) ) ),
                                                    array( 'type' => 'method',
                                                           'name' => 'register-search-object',
                                                           'frequency' => 'once',
                                                           'method' => 'registerSearchObject',
                                                           ),
                                                    array( 'type' => 'method',
                                                           'name' => 'create-notification',
                                                           'frequency' => 'once',
                                                           'method' => 'createNotificationEvent',
                                                           ),

                                                    array( 'type' => 'method',
                                                           'name' => 'remove-temporary-drafts',
                                                           'frequency' => 'once',
                                                           'method' => 'removeTemporaryDrafts'
                                                           ),

                                                    array( 'type' => 'trigger',
                                                           'name' => 'post_publish',
                                                           'keys' => array( 'object_id',
                                                                            'version' ) ),
                                                    ) );

$OperationList['move'] = array( 'name' => 'move',
                                'default_call_method' => array( 'include_file' => 'kernel/content/ezcontentoperationcollection.php',
                                                                'class' => 'eZContentOperationCollection' ),
                                'parameter_type' => 'standard',
                                'parameters' => array( array( 'name' => 'node_id',
                                                              'type' => 'integer',
                                                              'required' => true ),
                                                       array( 'name' => 'object_id',
                                                              'type' => 'integer',
                                                              'required' => true ),
                                                       array( 'name' => 'new_parent_node_id',
                                                              'type' => 'integer',
                                                              'required' => true ) ),
                                'keys' => array( 'node_id', 'object_id', 'new_parent_node_id' ),

                                'body' => array( array( 'type' => 'trigger',
                                                        'name' => 'pre_move',
                                                        'keys' => array( 'node_id',
                                                                         'object_id',
                                                                         'new_parent_node_id'
                                                                        ) ),
                                                  array( 'type' => 'method',
                                                        'name' => 'move-node',
                                                        'frequency' => 'once',
                                                        'method' => 'moveNode',
                                                        ),
                                                  array( 'type' => 'trigger',
                                                         'name' => 'post_move',
                                                         'keys' => array( 'node_id',
                                                                          'object_id',
                                                                          'new_parent_node_id'
                                                                         ) )
                                                )
                              );

$OperationList['addlocation'] = array(  'name' => 'addlocation',
                                        'default_call_method' => array( 'include_file' => 'kernel/content/ezcontentoperationcollection.php',
                                                                        'class' => 'eZContentOperationCollection' ),
                                        'parameter_type' => 'standard',
                                        'parameters' => array( array( 'name' => 'node_id',
                                                                      'type' => 'integer',
                                                                      'required' => true ),
                                                               array( 'name' => 'object_id',
                                                                      'type' => 'integer',
                                                                      'required' => true ),
                                                               array( 'name' => 'select_node_id_array',
                                                                      'type' => 'array',
                                                                      'required' => true ) ),
                                        'keys' => array( 'node_id', 'object_id', 'select_node_id_array' ),

                                        'body' => array( array( 'type' => 'trigger',
                                                                'name' => 'pre_addlocation',
                                                                'keys' => array( 'node_id',
                                                                                 'object_id',
                                                                                 'select_node_id_array'
                                                                                 )
                                                               ),
                                                         array( 'type' => 'method',
                                                                'name' => 'add-location',
                                                                'frequency' => 'once',
                                                                'method' => 'addAssignment',
                                                                ),
                                                         array( 'type' => 'trigger',
                                                                'name' => 'post_addlocation',
                                                                'keys' => array( 'node_id',
                                                                                 'object_id',
                                                                                 'select_node_id_array'
                                                                                 )
                                                               ),
                                                         )
                                     );

$OperationList['removelocation'] = array(   'name' => 'removelocation',
                                            'default_call_method' => array( 'include_file' => 'kernel/content/ezcontentoperationcollection.php',
                                                                            'class' => 'eZContentOperationCollection' ),
                                            'parameter_type' => 'standard',
                                            'parameters' => array( array( 'name' => 'node_list',
                                                                          'type' => 'array',
                                                                          'required' => true ), ),
                                            'keys' => array( 'node_list' ),

                                            'body' => array( array( 'type' => 'trigger',
                                                                    'name' => 'pre_removelocation',
                                                                    'keys' => array( 'node_list' )
                                                                  ),
                                                             array( 'type' => 'method',
                                                                    'name' => 'remove-location',
                                                                    'frequency' => 'once',
                                                                    'method' => 'removeNodes',
                                                                  ),
                                                             array( 'type' => 'trigger',
                                                                    'name' => 'post_removelocation',
                                                                    'keys' => array( 'node_list' ),
                                                                  ),
                                                           )
                                        );

$OperationList['delete'] = array( 'name' => 'delete',
                                            'default_call_method' => array( 'include_file' => 'kernel/content/ezcontentoperationcollection.php',
                                                                            'class' => 'eZContentOperationCollection' ),
                                            'parameter_type' => 'standard',
                                            'parameters' => array( array( 'name' => 'node_id_list',
                                                                          'type' => 'array',
                                                                          'required' => true ),
                                                                   array( 'name' => 'move_to_trash',
                                                                          'type' => 'integer',
                                                                          'required' => true ) ),
                                            'keys' => array( 'node_id_list', 'move_to_trash' ),

                                            'body' => array( array( 'type' => 'trigger',
                                                                    'name' => 'pre_delete',
                                                                    'keys' => array( 'node_id_list',
                                                                                     'move_to_trash'
                                                                                     ) ),
                                                             array( 'type' => 'method',
                                                                    'name' => 'delete',
                                                                    'frequency' => 'once',
                                                                    'method' => 'deleteObject',
                                                                    ),
                                                             array( 'type' => 'trigger',
                                                                    'name' => 'post_delete',
                                                                    'keys' => array( 'node_id_list',
                                                                                     'move_to_trash'
                                                                                     ) ),
                                                         ) );

$OperationList['hide'] = array( 'name' => 'hide',
                                'default_call_method' => array( 'include_file' => 'kernel/content/ezcontentoperationcollection.php',
                                                                'class' => 'eZContentOperationCollection' ),
                                'parameter_type' => 'standard',
                                'parameters' => array( array( 'name' => 'node_id',
                                                              'type' => 'integer',
                                                              'required' => true ),
                                                      ),
                                'keys' => array( 'node_id' ),

                                'body' => array( array( 'type' => 'trigger',
                                                        'name' => 'pre_hide',
                                                        'keys' => array( 'node_id' ),
                                                       ),
                                                 array( 'type' => 'method',
                                                        'name' => 'hide',
                                                        'frequency' => 'once',
                                                        'method' => 'changeHideStatus',
                                                        ),
                                                 array( 'type' => 'trigger',
                                                        'name' => 'post_hide',
                                                        'keys' => array( 'node_id' )
                                                       )
                                                 )
                              );

$OperationList['swap'] = array( 'name' => 'swap',
                                'default_call_method' => array( 'include_file' => 'kernel/content/ezcontentoperationcollection.php',
                                                                'class' => 'eZContentOperationCollection' ),
                                'parameter_type' => 'standard',
                                'parameters' => array( array( 'name' => 'node_id',
                                                              'type' => 'integer',
                                                              'required' => true ),
                                                       array( 'name' => 'selected_node_id',
                                                              'type' => 'integer',
                                                              'required' => true ),
                                                       array( 'name' => 'node_id_list',
                                                              'type' => 'array',
                                                              'required' => true ),
                                                      ),
                                'keys' => array( 'node_id', 'selected_node_id', 'node_id_list' ),

                                'body' => array( array( 'type' => 'trigger',
                                                        'name' => 'pre_swap',
                                                        'keys' => array( 'node_id_list' ),
                                                       ),
                                                 array( 'type' => 'method',
                                                        'name' => 'swap',
                                                        'frequency' => 'once',
                                                        'method' => 'swapNode',
                                                        ),
                                                 array( 'type' => 'trigger',
                                                        'name' => 'post_swap',
                                                        'keys' => array( 'node_id_list' )
                                                       )
                                                 )
                              );

$OperationList['updatesection'] = array( 'name' => 'updatesection',
                                         'default_call_method' => array( 'include_file' => 'kernel/content/ezcontentoperationcollection.php',
                                                                         'class' => 'eZContentOperationCollection' ),
                                        'parameter_type' => 'standard',
                                        'parameters' => array( array( 'name' => 'node_id',
                                                                      'type' => 'integer',
                                                                      'required' => true ),
                                                               array( 'name' => 'selected_section_id',
                                                                      'type' => 'integer',
                                                                      'required' => true ) ),

                                        'keys' => array( 'node_id', 'selected_section_id', ),

                                        'body' => array( array( 'type' => 'trigger',
                                                                'name' => 'pre_updatesection',
                                                                'keys' => array( 'node_id', 'selected_section_id' ),
                                                            ),
                                                        array( 'type' => 'method',
                                                               'name' => 'updatesection',
                                                               'frequency' => 'once',
                                                               'method' => 'updateSection',
                                                                ),
                                                        array( 'type' => 'trigger',
                                                                'name' => 'post_updatesection',
                                                                'keys' => array( 'node_id', 'selected_section_id' )
                                                            )
                                                        )
                              );
$OperationList['translationavailable'] = array( 'name' => 'translationavailable',
                                                'default_call_method' => array( 'include_file' => 'kernel/content/ezcontentoperationcollection.php',
                                                'class' => 'eZContentOperationCollection' ),
                                                'parameter_type' => 'standard',
                                                'parameters' => array( array( 'name' => 'object_id',
                                                                              'type' => 'integer',
                                                                              'required' => true ),
                                                                       array( 'name' => 'status',
                                              'type' => 'integer',
                                                                              'required' => false ),
                                                     ),
                                                'keys' => array( 'object_id', 'status' ),
                                                'body' => array( array( 'type' => 'trigger',
                                                                        'name' => 'pre_translationavailable',
                                                                        'keys' => array( 'object_id', 'status' ),
                                                                      ),
                                                                 array( 'type' => 'method',
                                                                        'name' => 'translationavailable',
                                                                        'frequency' => 'once',
                                    'method' => 'changeTranslationAvailableStatus',
                                                                      ),
                                                                 array( 'type' => 'trigger',
                                                                        'name' => 'post_translationavailable',
                                                                        'keys' => array( 'object_id' )
                                                                      )
                                                              )
                                            );

$OperationList['sort'] = array( 'name' => 'sort',
                                'default_call_method' => array( 'include_file' => 'kernel/content/ezcontentoperationcollection.php',
                                                                'class' => 'eZContentOperationCollection' ),
                                'parameter_type' => 'standard',
                                'parameters' => array( array( 'name' => 'node_id',
                                                              'type' => 'integer',
                                                              'required' => true ),
                                                       array( 'name' => 'sorting_field',
                                                              'type' => 'integer',
                                                              'required' => true ),
                                                       array( 'name' => 'sorting_order',
                                                              'type' => 'integer',
                                                              'required' => true ),
                                                      ),
                                'keys' => array( 'node_id', 'sorting_field', 'sorting_order' ),
                                'body' => array( array( 'type' => 'trigger',
                                                        'name' => 'pre_sort',
                                                        'keys' => array( 'node_id' ),
                                                       ),
                                                 array( 'type' => 'method',
                                                        'name' => 'sort',
                                                        'frequency' => 'once',
                                                        'method' => 'changeSortOrder',
                                                        ),
                                                 array( 'type' => 'trigger',
                                                        'name' => 'post_sort',
                                                        'keys' => array( 'node_id' )
                                                       )
                                                 )
                              );

$OperationList['updatepriority'] = array( 'name' => 'updatepriority',
                                'default_call_method' => array( 'include_file' => 'kernel/content/ezcontentoperationcollection.php',
                                                                'class' => 'eZContentOperationCollection' ),
                                'parameter_type' => 'standard',
                                'parameters' => array( array( 'name' => 'node_id',
                                                              'type' => 'integer',
                                                              'required' => true ),
                                                       array( 'name' => 'priority',
                                                              'type' => 'array',
                                                              'required' => true ),
                                                       array( 'name' => 'priority_id',
                                                              'type' => 'array',
                                                              'required' => true ),
                                                      ),
                                'keys' => array( 'node_id', 'priority', 'priority_id' ),
                                'body' => array( array( 'type' => 'trigger',
                                                        'name' => 'pre_updatepriority',
                                                        'keys' => array( 'node_id' ),
                                                       ),
                                                 array( 'type' => 'method',
                                                        'name' => 'updatepriority',
                                                        'frequency' => 'once',
                                                        'method' => 'updatePriority',
                                                        ),
                                                 array( 'type' => 'trigger',
                                                        'name' => 'post_updatepriority',
                                                        'keys' => array( 'node_id' )
                                                       )
                                                 )
                              );

$OperationList['updatemainassignment'] = array( 'name' => 'updatemainassignment',
                                'default_call_method' => array( 'include_file' => 'kernel/content/ezcontentoperationcollection.php',
                                                                'class' => 'eZContentOperationCollection' ),
                                'parameter_type' => 'standard',
                                'parameters' => array( array( 'name' => 'main_assignment_id',
                                                              'type' => 'integer',
                                                              'required' => true ),
                                                       array( 'name' => 'object_id',
                                                              'type' => 'array',
                                                              'required' => true ),
                                                       array( 'name' => 'main_assignment_parent_id',
                                                              'type' => 'array',
                                                              'required' => true ),
                                                      ),
                                'keys' => array( 'main_assignment_id', 'object_id', 'main_assignment_parent_id' ),
                                'body' => array( array( 'type' => 'trigger',
                                                        'name' => 'pre_updatemainassignment',
                                                        'keys' => array( 'main_assignment_id' ),
                                                       ),
                                                 array( 'type' => 'method',
                                                        'name' => 'updatemainassignment',
                                                        'frequency' => 'once',
                                                        'method' => 'updateMainAssignment',
                                                        ),
                                                 array( 'type' => 'trigger',
                                                        'name' => 'post_updatemainassignment',
                                                        'keys' => array( 'main_assignment_id' )
                                                       )
                                                 )
                              );

$OperationList['updateinitiallanguage'] = array( 'name' => 'updateinitiallanguage',
                                                 'default_call_method' => array( 'include_file' => 'kernel/content/ezcontentoperationcollection.php',
                                                 'class' => 'eZContentOperationCollection' ),
                                'parameter_type' => 'standard',
                                'parameters' => array( array( 'name' => 'object_id',
                                                              'type' => 'integer',
                                                              'required' => true ),
                                                       array( 'name' => 'new_initial_language_id',
                                                              'type' => 'integer',
                                                              'required' => true ),
                                                       array( 'name' => 'node_id',
                                                              'type' => 'integer',
                                                              'required' => true ) ),
                                'keys' => array( 'object_id', 'new_initial_language_id', 'node_id' ),
                                'body' => array( array( 'type' => 'trigger',
                                                        'name' => 'pre_updateinitiallanguage',
                                                        'keys' => array( 'object_id', 'new_initial_language_id', 'node_id' ),
                                                       ),
                                                 array( 'type' => 'method',
                                                        'name' => 'updateinitiallanguage',
                                                        'frequency' => 'once',
                                                        'method' => 'updateInitialLanguage',
                                                        ),
                                                 array( 'type' => 'trigger',
                                                        'name' => 'post_updateinitiallanguage',
                                                        'keys' => array( 'object_id', 'new_initial_language_id', 'node_id' )
                                                       )
                                                 )
                              );

$OperationList['updatealwaysavailable'] = array( 'name' => 'updatealwaysavailable',
                                                 'default_call_method' => array( 'include_file' => 'kernel/content/ezcontentoperationcollection.php',
                                                 'class' => 'eZContentOperationCollection' ),
                                'parameter_type' => 'standard',
                                'parameters' => array( array( 'name' => 'object_id',
                                                              'type' => 'integer',
                                                              'required' => true ),
                                                       array( 'name' => 'new_always_available',
                                                              'type' => 'integer',
                                                              'required' => true ),
                                                       array( 'name' => 'node_id',
                                                              'type' => 'integer',
                                                              'required' => true ) ),
                                'keys' => array( 'object_id', 'new_always_available', 'node_id' ),
                                'body' => array( array( 'type' => 'trigger',
                                                        'name' => 'pre_updatealwaysavailable',
                                                        'keys' => array( 'object_id', 'new_always_available' ),
                                                       ),
                                                 array( 'type' => 'method',
                                                        'name' => 'updatealwaysavailable',
                                                        'frequency' => 'once',
                                                        'method' => 'updateAlwaysAvailable',
                                                        ),
                                                 array( 'type' => 'trigger',
                                                        'name' => 'post_updateAlwaysAvailable',
                                                        'keys' => array( 'object_id', 'new_always_available', 'node_id' )
                                                       )
                                                 )
                              );

$OperationList['removetranslation'] = array( 'name' => 'removetranslation',
                                             'default_call_method' => array( 'include_file' => 'kernel/content/ezcontentoperationcollection.php',
                                             'class' => 'eZContentOperationCollection' ),
                                'parameter_type' => 'standard',
                                'parameters' => array(  array( 'name' => 'object_id',
                                                               'type' => 'integer',
                                                               'required' => true),
                                                        array( 'name' => 'language_id_list',
                                                              'type' => 'array',
                                                              'required' => true ),
                                                        array( 'name' => 'node_id',
                                                              'type' => 'integer',
                                                              'required' => true ) ),
                                'keys' => array( 'object_id', 'language_id_list', 'node_id' ),
                                'body' => array( array( 'type' => 'trigger',
                                                        'name' => 'pre_removetranslation',
                                                        'keys' => array( 'object_id', 'language_id_list', 'node_id' ),
                                                       ),
                                                 array( 'type' => 'method',
                                                        'name' => 'removetranslation',
                                                        'frequency' => 'once',
                                                        'method' => 'removeTranslation',
                                                        ),
                                                 array( 'type' => 'trigger',
                                                        'name' => 'post_removetranslation',
                                                        'keys' => array( 'object_id', 'language_id_list', 'node_id' )
                                                       )
                                                 )
                              );

$OperationList['updateobjectstate'] = array( 'name' => 'updateobjectstate',
                                             'default_call_method' => array( 'include_file' => 'kernel/content/ezcontentoperationcollection.php',
                                             'class' => 'eZContentOperationCollection' ),
                                'parameter_type' => 'standard',
                                'parameters' => array(  array( 'name' => 'object_id',
                                                               'type' => 'integer',
                                                               'required' => true),
                                                        array( 'name' => 'state_id_list',
                                                              'type' => 'array',
                                                              'required' => true ) ),
                                'keys' => array( 'object_id', 'state_id_list' ),
                                'body' => array( array( 'type' => 'trigger',
                                                        'name' => 'pre_updateobjectstate',
                                                        'keys' => array( 'object_id', 'state_id_list' ),
                                                       ),
                                                 array( 'type' => 'method',
                                                        'name' => 'updateobjectstate',
                                                        'frequency' => 'once',
                                                        'method' => 'updateObjectState',
                                                        ),
                                                 array( 'type' => 'trigger',
                                                        'name' => 'post_updateobjectstate',
                                                        'keys' => array( 'object_id', 'state_id_list' )
                                                       )
                                                 )
                              );

$OperationList['createnodefeed'] = array( 'name' => 'createnodefeed',
                                          'default_call_method' => array( 'include_file' => 'kernel/content/ezcontentoperationcollection.php',
                                          'class' => 'eZContentOperationCollection' ),
                                'parameter_type' => 'standard',
                                'parameters' => array(  array( 'name' => 'node_id',
                                                               'type' => 'integer',
                                                               'required' => true) ),
                                'keys' => array( 'node_id' ),
                                'body' => array( array( 'type' => 'trigger',
                                                        'name' => 'pre_createnodefeed',
                                                        'keys' => array( 'node_id' ),
                                                       ),
                                                 array( 'type' => 'method',
                                                        'name' => 'createnodefeed',
                                                        'frequency' => 'once',
                                                        'method' => 'createFeedForNode',
                                                        ),
                                                 array( 'type' => 'trigger',
                                                        'name' => 'post_createnodefeed',
                                                        'keys' => array( 'node_id' )
                                                       )
                                                 )
                              );

$OperationList['removenodefeed'] = array( 'name' => 'removenodefeed',
                                          'default_call_method' => array( 'include_file' => 'kernel/content/ezcontentoperationcollection.php',
                                          'class' => 'eZContentOperationCollection' ),
                                'parameter_type' => 'standard',
                                'parameters' => array(  array( 'name' => 'node_id',
                                                               'type' => 'integer',
                                                               'required' => true) ),
                                'keys' => array( 'node_id' ),
                                'body' => array( array( 'type' => 'trigger',
                                                        'name' => 'pre_removenodefeed',
                                                        'keys' => array( 'node_id' ),
                                                       ),
                                                 array( 'type' => 'method',
                                                        'name' => 'removenodefeed',
                                                        'frequency' => 'once',
                                                        'method' => 'removeFeedForNode',
                                                        ),
                                                 array( 'type' => 'trigger',
                                                        'name' => 'post_removenodefeed',
                                                        'keys' => array( 'node_id' )
                                                       )
                                                 )
                              );
?>
