/**
 * editor_plugin_src.js, ezoe variant of Emotions plugin 
 *
 * Copyright 2009, Moxiecode Systems AB
 * Released under LGPL License.
 *
 * License: http://tinymce.moxiecode.com/license
 * Contributing: http://tinymce.moxiecode.com/contributing
 */

(function(tinymce) {
        tinymce.create('tinymce.plugins.eZEmotionsPlugin', {
                init : function(ed, url) {
                        // Register commands
                        ed.addCommand('mceEmotion', function() {
                                ed.windowManager.open({
                                        file : url + '/emotions.htm',
                                        width : 250 + parseInt(ed.getLang('emotions.delta_width', 0)),
                                        height : 160 + parseInt(ed.getLang('emotions.delta_height', 0)),
                                        inline : 1
                                }, {
                                        plugin_url : url
                                });
                        });

                        // Register buttons
                        ed.addButton('emotions', {title : 'emotions.emotions_desc', cmd : 'mceEmotion'});
                },

                getInfo : function() {
                        return {
                                longname : 'eZ Emotions',
                                author : 'Moxiecode Systems AB & eZ Systems AS',
                                authorurl : 'http://tinymce.moxiecode.com',
                                infourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/emotions',
                                version : tinymce.majorVersion + "." + tinymce.minorVersion
                        };
                }
        });

        // Register plugin
        tinymce.PluginManager.add('ezemotions', tinymce.plugins.eZEmotionsPlugin);
})(tinymce);
