{* DO NOT EDIT THIS FILE! Use an override template instead. *}
<form method="post" action={"/shop/basket/"|ezurl}>

<div class="maincontentheader">
    <h1>{"Basket"|i18n("design/standard/shop")}</h1>
</div>
{section show=$removed_items}
<div class="warning">
    <h2>{"The following items were removed from your basket because the products were changed"|i18n("design/standard/shop",,)}</h2>
    <ul>
    {section name=RemovedItem loop=$removed_items}
        <li> <a href={concat("/content/view/full/",$RemovedItem:item.contentobject.main_node_id,"/")|ezurl}>{$RemovedItem:item.contentobject.name|wash}</a></li>
    {/section}
    </ul>
</div>
{/section}

{if not( $vat_is_known )}
<div class="message-warning">
<h2>{'VAT is unknown'|i18n( 'design/standard/shop' )}</h2>
{'VAT percentage is not yet known for some of the items being purchased.'|i18n( 'design/standard/shop' )}<br/>
{'This probably means that some information about you is not yet available and will be obtained during checkout.'|i18n( 'design/standard/shop' )}
</div>
{/if}

{section show=$error}
<div class="error">
    {switch match=$error}
    {case match=1}
       <h2>{"Attempted to add object without price to basket."|i18n("design/standard/shop",,)}</h2>
    {/case}
    {case match="aborted"}
       <h2>{"Your payment was aborted."|i18n("design/standard/shop",,)}</h2>
    {/case}
    {case match="invaliditemcount"}
       <h2>{"Incorrect quantity! The quantity of the product(s) must be numeric and not less than 1."|i18n("design/standard/shop",,)}</h2>
    {/case}
    {case match="options"}
       <h2>{"You have chosen invalid combination of options"|i18n("design/standard/shop",,)}</h2>
        <ul>
          {section var=UnvalidatedOptions loop=$error_data}
            <li>{$UnvalidatedOptions.item.name}</li>
                  <ul>
                      {section var=Errors loop=$UnvalidatedOptions.item.description}
                          <li>{$Errors.item}</li>
                      {/section}
                  </ul>
          {/section}
        </ul>
    {/case}
    {/switch}
</div>
{/section}

    {def $currency = fetch( 'shop', 'currency', hash( 'code', $basket.productcollection.currency_code ) )
         $locale = false()
         $symbol = false()}
    {if $currency}
        {set locale = $currency.locale
             symbol = $currency.symbol}
    {/if}

    {section name=Basket show=$basket.items}


<table class="list"  width="100%" cellspacing="0" cellpadding="0" border="0">
<tr>
	<th>
	{"Product"|i18n("design/standard/shop")}
	</th>
	<th>
	{"Count"|i18n("design/standard/shop")}
	</th>
	<th>
	{"VAT"|i18n("design/standard/shop")}
	</th>
	<th>
	{"Price ex. VAT"|i18n("design/standard/shop")}
	</th>
	<th>
	{"Price inc. VAT"|i18n("design/standard/shop")}
	</th>
	<th>
	{"Discount"|i18n("design/standard/shop")}
	</th>
	<th>
	{"Total price ex. VAT"|i18n("design/standard/shop")}
	</th>
	<th>
	{"Total price inc. VAT"|i18n("design/standard/shop")}
	</th>
	<th>
	&nbsp;
	</th>
</tr>
{section name=ProductItem loop=$basket.items sequence=array(bglight,bgdark)}
<tr>
	<td class="{$Basket:ProductItem:sequence}">
	<input type="hidden" name="ProductItemIDList[]" value="{$Basket:ProductItem:item.id}" />
	{*{$Basket:ProductItem:item.id}-*}
	<a href={concat("/content/view/full/",$Basket:ProductItem:item.node_id,"/")|ezurl}>{$Basket:ProductItem:item.object_name}</a>
	</td>
	<td class="{$Basket:ProductItem:sequence}">
	<input type="text" name="ProductItemCountList[]" value="{$Basket:ProductItem:item.item_count}" size="5" />

	</td>
	<td class="{$Basket:ProductItem:sequence}">
	{if ne( $Basket:ProductItem:item.vat_value, -1 )}
		{$Basket:ProductItem:item.vat_value} %
	{else}
		{'unknown'|i18n( 'design/standard/shop' )}
	{/if}
	</td>
	<td class="{$Basket:ProductItem:sequence}">
	{$Basket:ProductItem:item.price_ex_vat|l10n( 'currency', $locale, $symbol )}
	</td>
	<td class="{$Basket:ProductItem:sequence}">
	{$Basket:ProductItem:item.price_inc_vat|l10n( 'currency', $locale, $symbol )}
	</td>
	<td class="{$Basket:ProductItem:sequence}">
	{$Basket:ProductItem:item.discount_percent}%
	</td>
	<td class="{$Basket:ProductItem:sequence}">
	{$Basket:ProductItem:item.total_price_ex_vat|l10n( 'currency', $locale, $symbol )}
	</td>
	<td class="{$Basket:ProductItem:sequence}">
	{$Basket:ProductItem:item.total_price_inc_vat|l10n( 'currency', $locale, $symbol )}
	</td>
	<td class="{$Basket:ProductItem:sequence}">
	<input type="checkbox" name="RemoveProductItemDeleteList[]" value="{$Basket:ProductItem:item.id}" />
	</td>
</tr>
{section show=$Basket:ProductItem:item.item_object.option_list}
<tr>
  <td class="{$Basket:ProductItem:sequence}" colspan="4">
     <table class="shop-option_list">
<tr>
<td colspan="3">
{"Selected options"|i18n("design/standard/shop")}
</td>
</tr>
     {section name=Options loop=$Basket:ProductItem:item.item_object.option_list}
      <tr>
        <td width="33%">{$Basket:ProductItem:Options:item.name}</td>
        <td width="33%">{$Basket:ProductItem:Options:item.value}</td>
        <td width="33%">{$Basket:ProductItem:Options:item.price|l10n( 'currency', $locale, $symbol )}</td>
      </tr>
    {/section}
     </table>
   </td>
  <td class="{$Basket:ProductItem:sequence}" colspan="5">
  </td>
</tr>
{/section}
{/section}
<tr>
     <td colspan="8">
     <hr size="2" />
     </td>
     <td>
     </td>
</tr>
<tr>
     <td colspan="6">
     </td>
     <td>
     <b>{"Subtotal ex. VAT"|i18n("design/standard/shop")}</b>:
     </td>
     <td>
     <b>{"Subtotal inc. VAT"|i18n("design/standard/shop")}</b>:
     </td>
     <td>
     </td>
</tr>
<tr>
<td colspan="6">
</td>
<td>
{$basket.total_ex_vat|l10n( 'currency', $locale, $symbol )}
</td>
<td>
{$basket.total_inc_vat|l10n( 'currency', $locale, $symbol )}
</td>

{if is_set( $shipping_info )}
{* Show shipping type/cost. *}
<tr>
     <td colspan="6">
     <a href={$shipping_info.management_link|ezurl}>{'Shipping'|i18n( 'design/admin/shop/basket' )}{if $shipping_info.description} ({$shipping_info.description}){/if}</a>:
     </td>
     <td>
     {$shipping_info.cost|l10n( 'currency', $locale, $symbol )}:
     </td>
     <td>
     {$shipping_info.cost|l10n( 'currency', $locale, $symbol )}:
     </td>
     <td>
     </td>
</tr>
{* Show order total *}
<tr>
     <td colspan="6">
     <b>{'Order total'|i18n( 'design/admin/shop/basket' )}<b>:
     </td>
     <td>
     <b>{$total_inc_shipping_ex_vat|l10n( 'currency', $locale, $symbol )}</b>
     </td>
     <td>
     <b>{$total_inc_shipping_inc_vat|l10n( 'currency', $locale, $symbol )}</b>
     </td>
     <td>
     </td>
</tr>
{/if}

<td>
</td>
</tr>
</table>
<div class="buttonblock">
<input class="button" type="submit" name="RemoveProductItemButton" value="{'Remove'|i18n('design/standard/shop')}" /> &nbsp;
<input class="button" type="submit" name="StoreChangesButton" value="{'Store'|i18n('design/standard/shop')}" />
</div>

<div class="buttonblock">
<input class="button" type="submit" name="ContinueShoppingButton" value="{'Continue shopping'|i18n('design/standard/shop')}" />
<input class="button" type="submit" name="CheckoutButton" value="{'Checkout'|i18n('design/standard/shop')}" /> &nbsp;
</div>

{undef $currency $locale $symbol}

{section-else}

<div class="feedback">
<h2>{"You have no products in your basket"|i18n("design/standard/shop")}</h2>
</div>

{/section}


</form>
