/*
 * Decompiled with CFR 0.152.
 */
package org.ezsystems.solr.handler.ezfind;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.component.QueryElevationComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.plugin.SolrCoreAware;

public class eZFindRequestHandler
extends RequestHandlerBase
implements SolrCoreAware {
    private SolrCore core = null;
    private QueryElevationComponent elevationComponent = null;
    private String elevateConfigurationFileName = null;
    private static transient Logger log = Logger.getLogger(eZFindRequestHandler.class + "");
    public static final String CONF_PARAM_NAME = "elevate-configuration";

    public void init(NamedList args) {
    }

    private String getElevateConfigurationFileName() {
        if (this.elevateConfigurationFileName == null) {
            this.elevateConfigurationFileName = this.core.getSolrConfig().get("searchComponent[@class=\"solr.QueryElevationComponent\"]/str[@name=\"config-file\"]", "elevate.xml");
        }
        return this.elevateConfigurationFileName;
    }

    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) {
        String newElevateConfiguration = req.getParams().get(CONF_PARAM_NAME);
        if (newElevateConfiguration != null) {
            String f = this.getElevateConfigurationFileName();
            File fC = new File(this.core.getResourceLoader().getConfigDir(), f);
            if (fC.exists()) {
                try {
                    log.info("Updating " + fC);
                    FileWriter fw = new FileWriter(fC);
                    BufferedWriter out = new BufferedWriter(fw);
                    out.write(newElevateConfiguration);
                    out.close();
                    this.elevationComponent.inform(this.core);
                }
                catch (Exception e) {
                    log.info("Exception when updating " + fC.getAbsolutePath() + " : " + e.getMessage());
                    rsp.add("error", (Object)("Error when updating " + fC.getAbsolutePath() + " : " + e.getMessage()));
                }
            }
        }
    }

    public void inform(SolrCore core) {
        this.core = core;
        Map availableSearchComponents = core.getSearchComponents();
        for (Map.Entry e : availableSearchComponents.entrySet()) {
            if (e.getValue().getClass().getName() != "org.apache.solr.handler.component.QueryElevationComponent") continue;
            this.elevationComponent = (QueryElevationComponent)e.getValue();
            break;
        }
    }

    public String getDescription() {
        return "eZFind's dedicated request Handler.";
    }

    public String getVersion() {
        return "$Revision:$";
    }

    public String getSourceId() {
        return "$Id:$";
    }

    public String getSource() {
        return "$URL:$";
    }

    public String getName() {
        return "eZFindQueryHandler";
    }

    public SolrInfoMBean.Category getCategory() {
        return null;
    }

    public URL[] getDocs() {
        return null;
    }

    public NamedList getStatistics() {
        return null;
    }
}

