/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.ElementLabel;
import org.simpleframework.xml.core.Label;
import org.simpleframework.xml.core.Parameter;
import org.simpleframework.xml.core.ParameterContact;

class ElementParameter
implements Parameter {
    private final Constructor factory;
    private final Contact contact;
    private final Label label;
    private final String name;
    private final Class type;
    private final int index;

    public ElementParameter(Constructor factory, Element value, int index) throws Exception {
        this.contact = new Contact(value, factory, index);
        this.label = new ElementLabel(this.contact, value);
        this.type = this.label.getType();
        this.name = this.label.getName();
        this.factory = factory;
        this.index = index;
    }

    public String getName() throws Exception {
        return this.name;
    }

    public String getName(Context context) throws Exception {
        return this.label.getName(context);
    }

    public Class getType() {
        return this.factory.getParameterTypes()[this.index];
    }

    public Annotation getAnnotation() {
        return this.contact.getAnnotation();
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isRequired() {
        return this.label.isRequired();
    }

    public boolean isPrimitive() {
        return this.type.isPrimitive();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Contact
    extends ParameterContact<Element> {
        public Contact(Element label, Constructor factory, int index) {
            super(label, factory, index);
        }

        @Override
        public String getName() {
            return ((Element)this.label).name();
        }
    }
}

