/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DocumentAssignerDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.text.preprocessing.DocumentAssigner";
    public final String prefix = "DocumentAssigner";
    public final String title = "Assigns document to label candidates";
    public final String label = "";
    public final String description = "For each label candidate from <code>AllLabels.featureIndex</code> an <code>BitSet</code> with the assigned documents is constructed. The assignment algorithm is rather simple: in order to be assigned to a label, a document must contain at least one occurrence of each non-stop word from the label. <p> This class saves the following results to the <code>PreprocessingContext</code> : <ul> <li><code>AllLabels.documentIndices</code></li> </ul> <p> This class requires that <code>Tokenizer</code>, <code>CaseNormalizer</code>, <code>StopListMarker</code>, <code>PhraseExtractor</code> and <code>LabelFilterProcessor</code> be invoked first.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    @Override
    public String getPrefix() {
        return "DocumentAssigner";
    }

    @Override
    public String getTitle() {
        return "Assigns document to label candidates";
    }

    @Override
    public String getLabel() {
        return "";
    }

    @Override
    public String getDescription() {
        return "For each label candidate from <code>AllLabels.featureIndex</code> an <code>BitSet</code> with the assigned documents is constructed. The assignment algorithm is rather simple: in order to be assigned to a label, a document must contain at least one occurrence of each non-stop word from the label. <p> This class saves the following results to the <code>PreprocessingContext</code> : <ul> <li><code>AllLabels.documentIndices</code></li> </ul> <p> This class requires that <code>Tokenizer</code>, <code>CaseNormalizer</code>, <code>StopListMarker</code>, <code>PhraseExtractor</code> and <code>LabelFilterProcessor</code> be invoked first.";
    }

    @Override
    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    @Override
    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    @Override
    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    @Override
    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(DocumentAssignerDescriptor.attributes.exactPhraseAssignment);
        ownAttrs.add(DocumentAssignerDescriptor.attributes.minClusterSize);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(DocumentAssignerDescriptor.attributes.exactPhraseAssignment);
        allAttrs.add(DocumentAssignerDescriptor.attributes.minClusterSize);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public AttributeBuilder exactPhraseAssignment(boolean value) {
            this.map.put("DocumentAssigner.exactPhraseAssignment", value);
            return this;
        }

        public AttributeBuilder minClusterSize(int value) {
            this.map.put("DocumentAssigner.minClusterSize", value);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo exactPhraseAssignment = new AttributeInfo("DocumentAssigner.exactPhraseAssignment", "org.carrot2.text.preprocessing.DocumentAssigner", "exactPhraseAssignment", "Only exact phrase assignments. Assign only documents that contain the label in its\noriginal form, including the order of words. Enabling this option will cause less\ndocuments to be put in clusters, which result in higher precision of assignment,\nbut also a larger \"Other Topics\" group. Disabling this option will cause more\ndocuments to be put in clusters, which will make the \"Other Topics\" cluster\nsmaller, but also lower the precision of cluster-document assignments.", "Exact phrase assignment", "Only exact phrase assignments", "Assign only documents that contain the label in its original form, including the order of words. Enabling this option will cause less documents to be put in clusters, which result in higher precision of assignment, but also a larger \"Other Topics\" group. Disabling this option will cause more documents to be put in clusters, which will make the \"Other Topics\" cluster smaller, but also lower the precision of cluster-document assignments.", "Preprocessing", AttributeLevel.MEDIUM, null);
        public final AttributeInfo minClusterSize = new AttributeInfo("DocumentAssigner.minClusterSize", "org.carrot2.text.preprocessing.DocumentAssigner", "minClusterSize", "Determines the minimum number of documents in each cluster.", "Minimum cluster size", "Determines the minimum number of documents in each cluster", null, "Preprocessing", AttributeLevel.MEDIUM, null);

        private Attributes() {
        }
    }

    public static class Keys {
        public static final String EXACT_PHRASE_ASSIGNMENT = "DocumentAssigner.exactPhraseAssignment";
        public static final String MIN_CLUSTER_SIZE = "DocumentAssigner.minClusterSize";

        protected Keys() {
        }
    }
}

