/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.lucene;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.highlight.Formatter;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleFieldMapperDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.source.lucene.SimpleFieldMapper";
    public final String prefix = "";
    public final String title = "A simple <code>IFieldMapper</code> with one-to-one mapping between the default title, url and summary fields";
    public final String label = "";
    public final String description = "";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    @Override
    public String getPrefix() {
        return "";
    }

    @Override
    public String getTitle() {
        return "A simple <code>IFieldMapper</code> with one-to-one mapping between the default title, url and summary fields";
    }

    @Override
    public String getLabel() {
        return "";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    @Override
    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    @Override
    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    @Override
    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(SimpleFieldMapperDescriptor.attributes.titleField);
        ownAttrs.add(SimpleFieldMapperDescriptor.attributes.contentField);
        ownAttrs.add(SimpleFieldMapperDescriptor.attributes.urlField);
        ownAttrs.add(SimpleFieldMapperDescriptor.attributes.searchFields);
        ownAttrs.add(SimpleFieldMapperDescriptor.attributes.formatter);
        ownAttrs.add(SimpleFieldMapperDescriptor.attributes.contextFragments);
        ownAttrs.add(SimpleFieldMapperDescriptor.attributes.fragmentJoin);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(SimpleFieldMapperDescriptor.attributes.titleField);
        allAttrs.add(SimpleFieldMapperDescriptor.attributes.contentField);
        allAttrs.add(SimpleFieldMapperDescriptor.attributes.urlField);
        allAttrs.add(SimpleFieldMapperDescriptor.attributes.searchFields);
        allAttrs.add(SimpleFieldMapperDescriptor.attributes.formatter);
        allAttrs.add(SimpleFieldMapperDescriptor.attributes.contextFragments);
        allAttrs.add(SimpleFieldMapperDescriptor.attributes.fragmentJoin);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public AttributeBuilder titleField(String value) {
            this.map.put("org.carrot2.source.lucene.SimpleFieldMapper.titleField", value);
            return this;
        }

        public AttributeBuilder contentField(String value) {
            this.map.put("org.carrot2.source.lucene.SimpleFieldMapper.contentField", value);
            return this;
        }

        public AttributeBuilder urlField(String value) {
            this.map.put("org.carrot2.source.lucene.SimpleFieldMapper.urlField", value);
            return this;
        }

        public AttributeBuilder searchFields(List<String> value) {
            this.map.put("org.carrot2.source.lucene.SimpleFieldMapper.searchFields", value);
            return this;
        }

        public AttributeBuilder formatter(Formatter value) {
            this.map.put("org.carrot2.source.lucene.SimpleFieldMapper.formatter", value);
            return this;
        }

        public AttributeBuilder formatter(Class<? extends Formatter> clazz) {
            this.map.put("org.carrot2.source.lucene.SimpleFieldMapper.formatter", clazz);
            return this;
        }

        public AttributeBuilder contextFragments(int value) {
            this.map.put("org.carrot2.source.lucene.SimpleFieldMapper.contextFragments", value);
            return this;
        }

        public AttributeBuilder fragmentJoin(String value) {
            this.map.put("org.carrot2.source.lucene.SimpleFieldMapper.fragmentJoin", value);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo titleField = new AttributeInfo("org.carrot2.source.lucene.SimpleFieldMapper.titleField", "org.carrot2.source.lucene.SimpleFieldMapper", "titleField", "Document title field name.", "Document title field", "Document title field name", null, "Index field mapping", AttributeLevel.BASIC, null);
        public final AttributeInfo contentField = new AttributeInfo("org.carrot2.source.lucene.SimpleFieldMapper.contentField", "org.carrot2.source.lucene.SimpleFieldMapper", "contentField", "Document content field name.", "Document content field", "Document content field name", null, "Index field mapping", AttributeLevel.BASIC, null);
        public final AttributeInfo urlField = new AttributeInfo("org.carrot2.source.lucene.SimpleFieldMapper.urlField", "org.carrot2.source.lucene.SimpleFieldMapper", "urlField", "Document URL field name.", "Document URL field", "Document URL field name", null, "Index field mapping", AttributeLevel.MEDIUM, null);
        public final AttributeInfo searchFields = new AttributeInfo("org.carrot2.source.lucene.SimpleFieldMapper.searchFields", "org.carrot2.source.lucene.SimpleFieldMapper", "searchFields", "Index search field names. If not specified, title and content fields are used.", "Search fields", "Index search field names", "If not specified, title and content fields are used.", "Index field mapping", AttributeLevel.MEDIUM, null);
        public final AttributeInfo formatter = new AttributeInfo("org.carrot2.source.lucene.SimpleFieldMapper.formatter", "org.carrot2.source.lucene.SimpleFieldMapper", "formatter", "Snippet formatter for the highlighter. Highlighter is not used if <code>null</code>.", "Formatter", "Snippet formatter for the highlighter", "Highlighter is not used if <code>null</code>.", "Highlighter", AttributeLevel.ADVANCED, null);
        public final AttributeInfo contextFragments = new AttributeInfo("org.carrot2.source.lucene.SimpleFieldMapper.contextFragments", "org.carrot2.source.lucene.SimpleFieldMapper", "contextFragments", "Number of context fragments for the highlighter.", "Context fragments", "Number of context fragments for the highlighter", null, "Highlighter", AttributeLevel.ADVANCED, null);
        public final AttributeInfo fragmentJoin = new AttributeInfo("org.carrot2.source.lucene.SimpleFieldMapper.fragmentJoin", "org.carrot2.source.lucene.SimpleFieldMapper", "fragmentJoin", "A string used to join context fragments when highlighting.", "Join string", "A string used to join context fragments when highlighting", null, "Highlighter", AttributeLevel.ADVANCED, null);

        private Attributes() {
        }
    }

    public static class Keys {
        public static final String TITLE_FIELD = "org.carrot2.source.lucene.SimpleFieldMapper.titleField";
        public static final String CONTENT_FIELD = "org.carrot2.source.lucene.SimpleFieldMapper.contentField";
        public static final String URL_FIELD = "org.carrot2.source.lucene.SimpleFieldMapper.urlField";
        public static final String SEARCH_FIELDS = "org.carrot2.source.lucene.SimpleFieldMapper.searchFields";
        public static final String FORMATTER = "org.carrot2.source.lucene.SimpleFieldMapper.formatter";
        public static final String CONTEXT_FRAGMENTS = "org.carrot2.source.lucene.SimpleFieldMapper.contextFragments";
        public static final String FRAGMENT_JOIN = "org.carrot2.source.lucene.SimpleFieldMapper.fragmentJoin";

        protected Keys() {
        }
    }
}

