/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.output.metrics;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.core.Document;
import org.carrot2.core.attribute.Processing;
import org.carrot2.output.metrics.IClusteringMetric;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Input;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Bindable
abstract class IdealPartitioningBasedMetric
implements IClusteringMetric {
    @Input
    @Processing
    @Attribute
    public String partitionIdFieldName = "partitions";

    IdealPartitioningBasedMetric() {
    }

    Set<Object> getPartitions(List<Document> documents) {
        HashSet partitions = Sets.newHashSet();
        for (Document document : documents) {
            Collection documentPartitions = (Collection)document.getField(this.partitionIdFieldName);
            if (documentPartitions == null) continue;
            partitions.addAll(documentPartitions);
        }
        return partitions;
    }

    int getPartitionsCount(List<Document> documents) {
        return this.getPartitions(documents).size();
    }

    SetMultimap<Object, Document> getDocumentsByPartition(List<Document> documents) {
        HashMultimap index = HashMultimap.create();
        for (Document document : documents) {
            Collection partitions = (Collection)document.getField(this.partitionIdFieldName);
            for (Object partition : partitions) {
                index.put(partition, (Object)document);
            }
        }
        return ImmutableSetMultimap.copyOf((Multimap)index);
    }

    Map<Object, Integer> getDocumentCountByPartition(List<Document> documents) {
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)this.getDocumentsByPartition(documents).asMap(), (Function)new Function<Collection<Document>, Integer>(){

            public Integer apply(Collection<Document> documents) {
                return documents.size();
            }
        }));
    }
}

