/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix.factorization;

import org.apache.mahout.math.function.BinaryFunction;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.function.UnaryFunction;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.carrot2.matrix.MatrixUtils;
import org.carrot2.matrix.factorization.IterativeMatrixFactorizationBase;

public class LocalNonnegativeMatrixFactorization
extends IterativeMatrixFactorizationBase {
    public LocalNonnegativeMatrixFactorization(DoubleMatrix2D A) {
        super(A);
    }

    public void compute() {
        double eps = 1.0E-9;
        this.U = this.doubleFactory2D.make(this.A.rows(), this.k);
        this.V = this.doubleFactory2D.make(this.A.columns(), this.k);
        this.seedingStrategy.seed(this.A, this.U, this.V);
        DoubleMatrix2D Aeps = this.A.copy().assign(Functions.plus((double)eps));
        DoubleMatrix2D UV = this.doubleFactory2D.make(this.A.rows(), this.A.columns());
        DoubleMatrix2D VT = this.doubleFactory2D.make(this.A.columns(), this.k);
        DoubleMatrix2D UT = this.doubleFactory2D.make(this.A.rows(), this.k);
        double[] work = new double[this.U.columns()];
        BinaryFunction invDiv = Functions.swapArgs((BinaryFunction)Functions.div);
        BinaryFunction sqrtMult = Functions.chain((UnaryFunction)Functions.sqrt, (BinaryFunction)Functions.mult);
        UnaryFunction plusEps = Functions.plus((double)eps);
        if (this.stopThreshold >= 0.0) {
            this.updateApproximationError();
        }
        for (int i = 0; i < this.maxIterations; ++i) {
            this.U.zMult(this.V, UV, 1.0, 0.0, false, true);
            UV.assign(plusEps);
            UV.assign(Aeps, invDiv);
            UV.zMult(this.U, VT, 1.0, 0.0, true, false);
            this.V.assign(VT, sqrtMult);
            this.U.zMult(this.V, UV, 1.0, 0.0, false, true);
            UV.assign(plusEps);
            UV.assign(Aeps, invDiv);
            UV.zMult(this.V, UT, 1.0, 0.0, false, false);
            this.U.assign(UT, Functions.mult);
            MatrixUtils.normalizeColumnL1(this.U, work);
            ++this.iterationsCompleted;
            if (this.stopThreshold >= 0.0 && this.updateApproximationError()) break;
        }
        if (this.ordered) {
            this.order();
        }
    }

    public String toString() {
        return "LNMF-" + this.seedingStrategy.toString();
    }
}

