/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix.factorization;

import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.apache.mahout.math.matrix.doublealgo.Sorting;
import org.apache.mahout.math.matrix.linalg.Algebra;
import org.carrot2.matrix.NNIDoubleFactory2D;
import org.carrot2.matrix.factorization.IIterativeMatrixFactorization;
import org.carrot2.matrix.factorization.MatrixFactorizationBase;
import org.carrot2.matrix.factorization.seeding.ISeedingStrategy;
import org.carrot2.matrix.factorization.seeding.RandomSeedingStrategy;

abstract class IterativeMatrixFactorizationBase
extends MatrixFactorizationBase
implements IIterativeMatrixFactorization {
    protected int k = DEFAULT_K;
    protected static int DEFAULT_K = 15;
    protected int maxIterations = 15;
    protected static final int DEFAULT_MAX_ITERATIONS = 15;
    protected double stopThreshold = DEFAULT_STOP_THRESHOLD;
    protected static double DEFAULT_STOP_THRESHOLD = -1.0;
    protected ISeedingStrategy seedingStrategy = DEFAULT_SEEDING_STRATEGY;
    protected static final ISeedingStrategy DEFAULT_SEEDING_STRATEGY = new RandomSeedingStrategy(0);
    protected boolean ordered = false;
    protected static final boolean DEFAULT_ORDERED = false;
    protected double approximationError = -1.0;
    protected double[] approximationErrors = null;
    protected int iterationsCompleted = 0;
    protected double[] aggregates;

    public IterativeMatrixFactorizationBase(DoubleMatrix2D A) {
        super(A);
    }

    public void setK(int k) {
        this.k = k;
    }

    public int getK() {
        return this.k;
    }

    protected boolean updateApproximationError() {
        double newApproximationError;
        if (this.approximationErrors == null) {
            this.approximationErrors = new double[this.maxIterations + 1];
        }
        this.approximationErrors[this.iterationsCompleted] = newApproximationError = Algebra.normF((DoubleMatrix2D)this.U.zMult(this.V, null, 1.0, 0.0, false, true).assign(this.A, Functions.minus));
        if ((this.approximationError - newApproximationError) / this.approximationError < this.stopThreshold) {
            this.approximationError = newApproximationError;
            return true;
        }
        this.approximationError = newApproximationError;
        return false;
    }

    protected void order() {
        DoubleMatrix2D VT = this.V.viewDice();
        this.aggregates = new double[VT.rows()];
        for (int i = 0; i < this.aggregates.length; ++i) {
            this.aggregates[i] = -VT.viewRow(i).aggregate(Functions.plus, Functions.square);
        }
        double[] aggregatesCopy = (double[])this.aggregates.clone();
        this.V = NNIDoubleFactory2D.asNNIMatrix(Sorting.quickSort.sort(VT, this.aggregates).viewDice());
        this.U = NNIDoubleFactory2D.asNNIMatrix(Sorting.quickSort.sort(this.U.viewDice(), aggregatesCopy).viewDice());
        for (int i = 0; i < this.aggregates.length; ++i) {
            this.aggregates[i] = -this.aggregates[i];
        }
    }

    public ISeedingStrategy getSeedingStrategy() {
        return this.seedingStrategy;
    }

    public void setSeedingStrategy(ISeedingStrategy seedingStrategy) {
        this.seedingStrategy = seedingStrategy;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public double getStopThreshold() {
        return this.stopThreshold;
    }

    public void setStopThreshold(double stopThreshold) {
        this.stopThreshold = stopThreshold;
    }

    public double getApproximationError() {
        return this.approximationError;
    }

    public double[] getApproximationErrors() {
        return this.approximationErrors;
    }

    public int getIterationsCompleted() {
        return this.iterationsCompleted;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public double[] getAggregates() {
        return this.aggregates;
    }
}

