/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import org.carrot2.core.CachingProcessingComponentManager;
import org.carrot2.core.Controller;
import org.carrot2.core.IProcessingComponent;
import org.carrot2.core.IProcessingComponentManager;
import org.carrot2.core.PoolingProcessingComponentManager;
import org.carrot2.core.SimpleProcessingComponentManager;
import org.carrot2.util.annotations.AspectModified;
import org.carrot2.util.pool.FixedSizePool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ControllerFactory {
    private ControllerFactory() {
    }

    public static Controller createSimple() {
        return ControllerFactory.create(false, new Class[0]);
    }

    public static Controller createPooling() {
        return ControllerFactory.create(true, new Class[0]);
    }

    public static Controller createPooling(int instancePoolSize) {
        return ControllerFactory.create(instancePoolSize, new Class[0]);
    }

    public static Controller createCaching(Class<? extends IProcessingComponent> ... cachedProcessingComponents) {
        return ControllerFactory.create(false, cachedProcessingComponents);
    }

    public static Controller createCachingPooling(Class<? extends IProcessingComponent> ... cachedProcessingComponents) {
        return ControllerFactory.create(true, cachedProcessingComponents);
    }

    public static Controller create(boolean componentPooling, Class<? extends IProcessingComponent> ... cachedProcessingComponents) {
        IProcessingComponentManager baseManager = componentPooling ? new PoolingProcessingComponentManager() : new SimpleProcessingComponentManager();
        return new Controller(ControllerFactory.addCachingManager(baseManager, cachedProcessingComponents));
    }

    public static Controller create(int instancePoolSize, Class<? extends IProcessingComponent> ... cachedProcessingComponents) {
        if (instancePoolSize <= 0) {
            throw new IllegalArgumentException("Instance pool size must be greater than zero: " + instancePoolSize);
        }
        PoolingProcessingComponentManager baseManager = new PoolingProcessingComponentManager(new FixedSizePool<IProcessingComponent, String>(instancePoolSize));
        return new Controller(ControllerFactory.addCachingManager(baseManager, cachedProcessingComponents));
    }

    @AspectModified(value="Throws an exception in .NET")
    private static IProcessingComponentManager addCachingManager(IProcessingComponentManager baseManager, Class<? extends IProcessingComponent> ... cachedProcessingComponents) {
        if (cachedProcessingComponents.length == 0) {
            return baseManager;
        }
        return new CachingProcessingComponentManager(baseManager, cachedProcessingComponents);
    }
}

