/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.matrix.linalg;

import java.io.Serializable;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.matrix.DoubleFactory2D;
import org.apache.mahout.math.matrix.DoubleMatrix1D;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.apache.mahout.math.matrix.linalg.Property;

@Deprecated
public class CholeskyDecomposition
implements Serializable {
    private final DoubleMatrix2D L;
    private final int n;
    private boolean isSymmetricPositiveDefinite;

    public CholeskyDecomposition(DoubleMatrix2D A) {
        int j;
        Property.checkSquare(A);
        this.n = A.rows();
        this.L = A.like(this.n, this.n);
        this.isSymmetricPositiveDefinite = A.columns() == this.n;
        DoubleMatrix1D[] Lrows = new DoubleMatrix1D[this.n];
        for (j = 0; j < this.n; ++j) {
            Lrows[j] = this.L.viewRow(j);
        }
        for (j = 0; j < this.n; ++j) {
            int k;
            double d = 0.0;
            for (k = 0; k < j; ++k) {
                double s = Lrows[k].zDotProduct(Lrows[j], 0, k);
                s = (A.getQuick(j, k) - s) / this.L.getQuick(k, k);
                Lrows[j].setQuick(k, s);
                d += s * s;
                this.isSymmetricPositiveDefinite = this.isSymmetricPositiveDefinite && A.getQuick(k, j) == A.getQuick(j, k);
            }
            d = A.getQuick(j, j) - d;
            this.isSymmetricPositiveDefinite = this.isSymmetricPositiveDefinite && d > 0.0;
            this.L.setQuick(j, j, Math.sqrt(Math.max(d, 0.0)));
            for (k = j + 1; k < this.n; ++k) {
                this.L.setQuick(j, k, 0.0);
            }
        }
    }

    public DoubleMatrix2D getL() {
        return this.L;
    }

    public boolean isSymmetricPositiveDefinite() {
        return this.isSymmetricPositiveDefinite;
    }

    public DoubleMatrix2D solve(DoubleMatrix2D B) {
        DoubleMatrix2D X = B.copy();
        int nx = B.columns();
        for (int c = 0; c < nx; ++c) {
            int k;
            double sum;
            int i;
            for (i = 0; i < this.n; ++i) {
                sum = B.getQuick(i, c);
                for (k = i - 1; k >= 0; --k) {
                    sum -= this.L.getQuick(i, k) * X.getQuick(k, c);
                }
                X.setQuick(i, c, sum / this.L.getQuick(i, i));
            }
            for (i = this.n - 1; i >= 0; --i) {
                sum = X.getQuick(i, c);
                for (k = i + 1; k < this.n; ++k) {
                    sum -= this.L.getQuick(k, i) * X.getQuick(k, c);
                }
                X.setQuick(i, c, sum / this.L.getQuick(i, i));
            }
        }
        return X;
    }

    private DoubleMatrix2D XXXsolveBuggy(DoubleMatrix2D B) {
        int i;
        int k;
        if (B.rows() != this.n) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isSymmetricPositiveDefinite) {
            throw new IllegalArgumentException("Matrix is not symmetric positive definite.");
        }
        DoubleMatrix2D X = B.copy();
        DoubleMatrix1D[] Xrows = new DoubleMatrix1D[this.n];
        for (k = 0; k < this.n; ++k) {
            Xrows[k] = X.viewRow(k);
        }
        for (k = 0; k < this.n; ++k) {
            for (i = k + 1; i < this.n; ++i) {
                Xrows[i].assign(Xrows[k], Functions.minusMult(this.L.getQuick(i, k)));
            }
            Xrows[k].assign(Functions.div(this.L.getQuick(k, k)));
        }
        for (k = this.n - 1; k >= 0; --k) {
            Xrows[k].assign(Functions.div(this.L.getQuick(k, k)));
            for (i = 0; i < k; ++i) {
                Xrows[i].assign(Xrows[k], Functions.minusMult(this.L.getQuick(k, i)));
            }
        }
        return X;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("--------------------------------------------------------------------------\n");
        buf.append("CholeskyDecomposition(A) --> isSymmetricPositiveDefinite(A), L, inverse(A)\n");
        buf.append("--------------------------------------------------------------------------\n");
        buf.append("isSymmetricPositiveDefinite = ");
        String unknown = "Illegal operation or error: ";
        try {
            buf.append(String.valueOf(this.isSymmetricPositiveDefinite()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown).append(exc.getMessage());
        }
        buf.append("\n\nL = ");
        try {
            buf.append(String.valueOf((Object)this.getL()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown).append(exc.getMessage());
        }
        buf.append("\n\ninverse(A) = ");
        try {
            buf.append(String.valueOf((Object)this.solve(DoubleFactory2D.dense.identity(this.L.rows()))));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown).append(exc.getMessage());
        }
        return buf.toString();
    }
}

