/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.Arrays;
import org.apache.mahout.math.function.IntLongProcedure;
import org.apache.mahout.math.function.IntProcedure;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.list.LongArrayList;
import org.apache.mahout.math.map.AbstractIntLongMap;
import org.apache.mahout.math.map.HashFunctions;

public class OpenIntLongHashMap
extends AbstractIntLongMap {
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;
    protected static final int NO_KEY_VALUE = 0;
    protected int[] table;
    protected long[] values;
    protected byte[] state;
    protected int freeEntries;

    public OpenIntLongHashMap() {
        this(277);
    }

    public OpenIntLongHashMap(int initialCapacity) {
        this(initialCapacity, 0.2, 0.5);
    }

    public OpenIntLongHashMap(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    public void clear() {
        Arrays.fill(this.state, (byte)0);
        this.distinct = 0;
        this.freeEntries = this.table.length;
        this.trimToSize();
    }

    public Object clone() {
        OpenIntLongHashMap copy = (OpenIntLongHashMap)super.clone();
        copy.table = (int[])copy.table.clone();
        copy.values = (long[])copy.values.clone();
        copy.state = (byte[])copy.state.clone();
        return copy;
    }

    public boolean containsKey(int key) {
        return this.indexOfKey(key) >= 0;
    }

    public boolean containsValue(long value) {
        return this.indexOfValue(value) >= 0;
    }

    public void ensureCapacity(int minCapacity) {
        if (this.table.length < minCapacity) {
            int newCapacity = this.nextPrime(minCapacity);
            this.rehash(newCapacity);
        }
    }

    public boolean forEachKey(IntProcedure procedure) {
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || procedure.apply(this.table[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachPair(IntLongProcedure procedure) {
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || procedure.apply(this.table[i], this.values[i])) continue;
            return false;
        }
        return true;
    }

    public long get(int key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return 0L;
        }
        return this.values[i];
    }

    protected int indexOfInsertion(int key) {
        int length = this.table.length;
        int hash = HashFunctions.hash(key) & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (this.state[i] == 1 && this.table[i] != key) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (this.state[i] == 2) {
            int j = i;
            while (this.state[i] != 0 && (this.state[i] == 2 || this.table[i] != key)) {
                if ((i -= decrement) >= 0) continue;
                i += length;
            }
            if (this.state[i] == 0) {
                i = j;
            }
        }
        if (this.state[i] == 1) {
            return -i - 1;
        }
        return i;
    }

    protected int indexOfKey(int key) {
        int length = this.table.length;
        int hash = HashFunctions.hash(key) & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (this.state[i] != 0 && (this.state[i] == 2 || this.table[i] != key)) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (this.state[i] == 0) {
            return -1;
        }
        return i;
    }

    protected int indexOfValue(long value) {
        long[] val = this.values;
        byte[] stat = this.state;
        int i = stat.length;
        while (--i >= 0) {
            if (stat[i] != 1 || val[i] != value) continue;
            return i;
        }
        return -1;
    }

    public void keys(IntArrayList list) {
        list.setSize(this.distinct);
        int[] elements = list.elements();
        int j = 0;
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1) continue;
            elements[j++] = this.table[i];
        }
    }

    public void pairsMatching(IntLongProcedure condition, IntArrayList keyList, LongArrayList valueList) {
        keyList.clear();
        valueList.clear();
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || !condition.apply(this.table[i], this.values[i])) continue;
            keyList.add(this.table[i]);
            valueList.add(this.values[i]);
        }
    }

    public boolean put(int key, long value) {
        int i = this.indexOfInsertion(key);
        if (i < 0) {
            i = -i - 1;
            this.values[i] = value;
            return false;
        }
        if (this.distinct > this.highWaterMark) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
            return this.put(key, value);
        }
        this.table[i] = key;
        this.values[i] = value;
        if (this.state[i] == 0) {
            --this.freeEntries;
        }
        this.state[i] = 1;
        ++this.distinct;
        if (this.freeEntries < 1) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return true;
    }

    public long adjustOrPutValue(int key, long newValue, long incrValue) {
        int i = this.indexOfInsertion(key);
        if (i < 0) {
            int n = i = -i - 1;
            this.values[n] = this.values[n] + incrValue;
            return this.values[i];
        }
        this.put(key, newValue);
        return newValue;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.table.length;
        int[] oldTable = this.table;
        long[] oldValues = this.values;
        byte[] oldState = this.state;
        this.table = new int[newCapacity];
        this.values = new long[newCapacity];
        this.state = new byte[newCapacity];
        this.lowWaterMark = this.chooseLowWaterMark(newCapacity, this.minLoadFactor);
        this.highWaterMark = this.chooseHighWaterMark(newCapacity, this.maxLoadFactor);
        this.freeEntries = newCapacity - this.distinct;
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldState[i] != 1) continue;
            int element = oldTable[i];
            int index = this.indexOfInsertion(element);
            this.table[index] = element;
            this.values[index] = oldValues[i];
            this.state[index] = 1;
        }
    }

    public boolean removeKey(int key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return false;
        }
        this.state[i] = 2;
        --this.distinct;
        if (this.distinct < this.lowWaterMark) {
            int newCapacity = this.chooseShrinkCapacity(this.distinct, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return true;
    }

    protected void setUp(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        int capacity = initialCapacity;
        super.setUp(capacity, minLoadFactor, maxLoadFactor);
        capacity = this.nextPrime(capacity);
        if (capacity == 0) {
            capacity = 1;
        }
        this.table = new int[capacity];
        this.values = new long[capacity];
        this.state = new byte[capacity];
        this.minLoadFactor = minLoadFactor;
        this.maxLoadFactor = capacity == Integer.MAX_VALUE ? 1.0 : maxLoadFactor;
        this.distinct = 0;
        this.freeEntries = capacity;
        this.lowWaterMark = 0;
        this.highWaterMark = this.chooseHighWaterMark(capacity, this.maxLoadFactor);
    }

    public void trimToSize() {
        int newCapacity = this.nextPrime((int)(1.0 + 1.2 * (double)this.size()));
        if (this.table.length > newCapacity) {
            this.rehash(newCapacity);
        }
    }

    public void values(LongArrayList list) {
        list.setSize(this.distinct);
        long[] elements = list.elements();
        int j = 0;
        int i = this.state.length;
        while (i-- > 0) {
            if (this.state[i] != 1) continue;
            elements[j++] = this.values[i];
        }
    }

    protected void getInternalFactors(int[] capacity, double[] minLoadFactor, double[] maxLoadFactor) {
        capacity[0] = this.table.length;
        minLoadFactor[0] = this.minLoadFactor;
        maxLoadFactor[0] = this.maxLoadFactor;
    }
}

